package mandelbrotExplorer;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

@SuppressWarnings("serial")
public class HistoryTree extends JScrollPane {
	private JTree tree;
	private DefaultTreeModel tm;
	private DefaultMutableTreeNode currentParentNode;

	private Mandelbrot mandel;
	
	public HistoryTree(final Mandelbrot m){

		this.mandel = m;
		DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("history");
		tm = new DefaultTreeModel(rootNode);
		currentParentNode = (DefaultMutableTreeNode)tm.getRoot();
		
		tree = new JTree(tm);
		tree.setEditable(false);
		tree.setExpandsSelectedPaths(true);
		this.getViewport().add(tree,null);
		//----------------------------------------------
		tree.addTreeSelectionListener(new TreeSelectionListener(){
			public void valueChanged(TreeSelectionEvent e) {
				TreePath selectPath = e.getPath();
				if( selectPath!=null ){
					//@[U[If[^Mandelbrotʂɕ\
					DefaultMutableTreeNode node=(DefaultMutableTreeNode)selectPath.getLastPathComponent();
					if( node.getUserObject().getClass()==MandelbrotSet.class ){
						DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
						//[U[INodeeNodeƂāA񂩂̓f[^ǉĂB
						// A[U[Node̍ŉ[Iꍇ́AeNodeɒǉĂB
				    	if( parentNode==null || parentNode.getIndex(node) < parentNode.getChildCount()-1 ){
				    		currentParentNode = node;
				    	}else{
				    		currentParentNode = parentNode;
				    	}
						//System.out.print("valueChanged currentParentNode "+currentParentNode+" pX "+tp);

				    	MandelbrotSet m = (MandelbrotSet)node.getUserObject();
						if( mandel.getMandelbrotSet()==null || !mandel.getMandelbrotSet().equals(m) ){
							mandel.setMandelbrotSet(m);
						}
					}
				}
			}
		});
	}
	
	public void addRow(final MandelbrotSet m){
		DefaultMutableTreeNode newNode=new DefaultMutableTreeNode(m);
		
		//System.out.println("addRow "+m);
		if( currentParentNode.getUserObject().getClass()!=MandelbrotSet.class ){
			// ŏaddRowłrootNodeMandelbrotSet
			currentParentNode.setUserObject(m);
			tm.reload();
		}else{
			MandelbrotSet parentMandel,lastMandel=null;
			parentMandel = (MandelbrotSet)(currentParentNode.getUserObject());
			if( currentParentNode.getChildCount()>0 ){
				lastMandel = (MandelbrotSet)((DefaultMutableTreeNode)currentParentNode.getLastChild()).getUserObject();
			}
			//System.out.println("parentMandel "+parentMandel);System.out.println("lastMandel   "+lastMandel);
			if( currentParentNode.getChildCount()!=0 || !parentMandel.equals(m) ){
								//@PԖڂ̎qɐeƓf[^ǉȂi[U[IŎqĂ܂̂hj
				if( lastMandel==null || !lastMandel.equals(m) ){	// NodeƓf[^͒ǉȂ
					//System.out.println("ǉ");
					tm.insertNodeInto(newNode,currentParentNode,currentParentNode.getChildCount());
					
					// ǉnewNodeI
					tree.setSelectionPath(new TreePath(tm.getPathToRoot(newNode)));
					// ǉnewNode悤autoScroll
					tree.scrollPathToVisible(new TreePath(tm.getPathToRoot(newNode)));
					this.repaint(); // ȂƁAIEłJAppletŏJTree̕\ꂽBiFireFoxł́AꂪĂȂj
				}
			}
		}
	}

}
