package mandelbrotExplorer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MandelbrotExplorer extends JFrame {
	private static final long serialVersionUID = 1L;
	private Mandelbrot mandel;
	private MandelbrotExplorer me;
	private JSplitPane jsp;
	private HistoryTree ht;
	private JCheckBoxMenuItem viewHistory;
	final private int HistoryTreeWidth = 300;
	
	public MandelbrotExplorer()  {
		me = this;
		//-----------------------------------------------------
		JMenuBar menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("t@C");
		JMenuItem fileExitItem = new JMenuItem("I");
		fileExitItem.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				System.exit(0); // ̏I̎dHRuntimeExceptionH
			}
		});
		fileMenu.add(fileExitItem);
		
		menuBar.add(fileMenu);
		//-----------------------------------------------------
		JMenu viewMenu = new JMenu("\");
		viewHistory = new JCheckBoxMenuItem("",true);
		viewMenu.add(viewHistory);
		viewHistory.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e) {
				if( viewHistory.getState()==true ){
					jsp.setDividerLocation(HistoryTreeWidth);
					ht.setVisible(true);
				}else{
					jsp.setDividerLocation(0);
					ht.setVisible(false);
				}
			}
		});
		
		
		//viewMenu.add(new JCheckBoxMenuItem("ubN}[N"));
		
		menuBar.add(viewMenu);

		this.setJMenuBar(menuBar);
		//-----------------------------------------------------
		jsp = new JSplitPane();
		this.getContentPane().add(jsp);
		//--------------------------------
		mandel = new Mandelbrot(new Rectangle2D.Double(-2.0 , -1.25 , 2.5 , 2.5));
		mandel.addMandelbrotListener(new MandelbrotAdapter(){
			public void regionUpdate(MandelbrotEvent e){
				me.setTitle(e.toString());
				ht.addRow(mandel.getMandelbrotSet());
			}
		});
		jsp.setRightComponent(mandel);
		//-----------------------------------------------------

        ht = new HistoryTree(mandel);
        ht.setPreferredSize(new Dimension(HistoryTreeWidth,mandel.getPreferredSize().height));
        
		jsp.setLeftComponent(ht);
		
		//-----------------------------------------------------
		
        
		this.setResizable(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.pack();
		this.setVisible(true);
		
		/*
		new Thread(new Runnable(){
			public void run(){
				try {
					double rLeft,rRight,iTop,iBottom;
					Thread.sleep(10000);
					
					rLeft=-0.973;rRight=-0.968;iTop=-0.253;iBottom=-0.248;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=0.2622;rRight=0.2627;iTop=-0.002;iBottom=-0.0025;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.253;iTop=0.0237;iBottom=0.0257;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					Thread.sleep(10000);

					rLeft=-1.255;rRight=-1.2545; iTop=0.0252; iBottom=0.0257;
					mandel.setRegion(new Rectangle2D.Double(rLeft , iTop , rRight-rLeft , iBottom-iTop));
					
				} catch (InterruptedException e) {
				}
			}
		}).start();
		*/
	}
	
	public static void main(String[] args) {
		new MandelbrotExplorer();
	}
	
	/*
	 * 
	 * Ql
	 * utN^bfRNVvAFGGAsFTCGX
	 * ubɂASYTvAFFAsFZp]_
	 * 
	 */
}

