package mandelbrotExplorer;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

import javax.swing.JApplet;
import javax.swing.JSplitPane;

public class MandelbrotExplorerApplet extends JApplet {

	private static final long serialVersionUID = 1L;
	
	Mandelbrot mandel;
	private JSplitPane jsp;
	private HistoryTree ht;
	private int HistoryTreeWidth = 300;
	
	public MandelbrotExplorerApplet(){
		
	}
	
	@Override
	public void init() {
		double rLeft,iTop,rWidth,iHeight;
		
		if( this.getParameter("r_left")!=null ){
			rLeft = Double.parseDouble( this.getParameter("r_left") );
		}else{
			rLeft=-2.0;
		}
		if( this.getParameter("i_top")!=null ){
			iTop = Double.parseDouble( this.getParameter("i_top") );
		}else{
			iTop=-1.25;
		}
		if( this.getParameter("r_width")!=null ){
			rWidth = Double.parseDouble( this.getParameter("r_width") );
		}else{
			rWidth=2.5;
		}
		if( this.getParameter("i_height")!=null ){
			iHeight = Double.parseDouble( this.getParameter("i_height") );
		}else{
			iHeight=2.5;
		}
		if( this.getParameter("history_Width")!=null ){
			HistoryTreeWidth = Integer.parseInt( this.getParameter("history_Width") );
		}else{
			HistoryTreeWidth=300;
		}
		
		//-----------------------------------------------------
		jsp = new JSplitPane();
		
		mandel = new Mandelbrot(new Rectangle2D.Double(rLeft, iTop, rWidth, iHeight));
		mandel.setSize(this.getWidth()-HistoryTreeWidth , this.getHeight());
		jsp.setRightComponent(mandel);

        ht = new HistoryTree(mandel);
        ht.setPreferredSize(new Dimension(HistoryTreeWidth,mandel.getPreferredSize().height));
		jsp.setLeftComponent(ht);
		
		jsp.setDividerLocation(HistoryTreeWidth);
		this.getContentPane().add(jsp);
		
		//--------------------------------
		mandel.addMandelbrotListener(new MandelbrotAdapter(){
			public void regionUpdate(MandelbrotEvent e){
				ht.addRow(mandel.getMandelbrotSet());
			}
		});
		//-----------------------------------------------------
	}

}
