package mandelbrotExplorer;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MandelbrotSet {

	final private double scaleR,scaleI;
	final private Point2D.Double leftTop;

	public  MandelbrotSet(int width,int height, Rectangle2D.Double r){

		this.scaleR = r.width/(double)width;
		this.scaleI = r.height/(double)height;

		leftTop = new Point2D.Double(r.x , r.y);
	}
	
	public MandelbrotSet(Point2D.Double leftTop,double scaleR,double scaleI){
		this.leftTop = new Point2D.Double(leftTop.x,leftTop.y);
		this.scaleR = scaleR;
		this.scaleI = scaleI;
		
	}
	
	public double getLeft(){
		return leftTop.getX();
	}

	public double getTop(){
		return leftTop.getY();
	}

	public double getScaleI() {
		return scaleI;
	}


	public double getScaleR() {
		return scaleR;
	}

	public int calcMandel(int r,int i,int max_count){
		return calcMandel(leftTop.getX()+r*scaleR , leftTop.getY()+i*scaleI ,max_count);
	}

	public int calcMandel(final double cr,final double ci,final int max_count){
		double r,i;
		double rr,ii;
		int n;

		r=0.0;
		i=0.0;
		rr = 0.0;
		ii = 0.0;
		for(n=0;n<=max_count;++n){
			i=(2.0*r*i)+ci;
			r=rr-ii+cr;
			rr=r*r;
			ii=i*i;
			if( (rr+ii)>4.0 ) return n;
		}
		return -1;
	}
	
	public String toString(){
		return String.format("(%e,%e):scale(%e,%e)", leftTop.x,leftTop.y ,scaleR, scaleI);
	}
	
	public boolean equals(Object o) {
		if( this==o) {
			return true;
		}
		if( o instanceof MandelbrotSet ) {
			MandelbrotSet m =(MandelbrotSet)o; 
			if( this.getLeft() != m.getLeft() ){ return false; }
			if( this.getTop() != m.getTop() ){ return false; }
			if( this.getScaleR() != m.getScaleR() ){ return false; }
			if( this.getScaleI() != m.getScaleI() ){ return false; }
			return true;
		}
		return false;
	}
	
	public int hashCode() {
		//  hashl̗LɂĂ͖؁BƂ肠B
		int hash = 1;
		hash = hash * 31 + (Double.valueOf(leftTop.x)).hashCode();
		hash = hash * 31 + (Double.valueOf(leftTop.y)).hashCode();
		hash = hash * 31 + (Double.valueOf(scaleR)).hashCode();
		hash = hash * 31 + (Double.valueOf(scaleI)).hashCode();
		return hash;
	}
}
