/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.chart.DateLogAxis;
import org.kaoriha.marimite.viewer.chart.ToolTipGenerator;
import org.kaoriha.marimite.viewer.chart.Updater;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

public class ChartUtil {
    public static ChartPanel getChartPanel() {
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        DateLogAxis xAxis = new DateLogAxis();
        xAxis.setInverted(true);
        NumberAxis yAxis = new NumberAxis();
        DeviationRenderer renderer = new DeviationRenderer(true, true);
        renderer.setAlpha(0.2f);
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.GREEN);
        renderer.setSeriesFillPaint(0, renderer.getSeriesPaint(0));
        renderer.setSeriesFillPaint(1, renderer.getSeriesPaint(1));
        renderer.setSeriesFillPaint(2, renderer.getSeriesPaint(2));
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        XYLineAndShapeRenderer sr = new XYLineAndShapeRenderer(false, true);
        sr.setSeriesPaint(0, (Paint)Color.YELLOW);
        plot.setRenderer(1, (XYItemRenderer)sr);
        plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        JFreeChart chart = new JFreeChart(null, UIManager.getFont("Label.font"), (Plot)plot, true);
        ChartPanel panel = new ChartPanel(chart);
        JPopupMenu pm = panel.getPopupMenu();
        pm.addSeparator();
        JMenuItem removeMenu = new JMenuItem("Remove");
        removeMenu.addActionListener(new RemoveListener(panel));
        pm.add(removeMenu);
        pm.insert(new JPopupMenu.Separator(), 0);
        JMenu nextMenu = new JMenu("Next");
        pm.insert(nextMenu, 0);
        JMenu prevMenu = new JMenu("Prev");
        pm.insert(prevMenu, 0);
        pm.addPopupMenuListener(new BuildNavigationListener(panel, nextMenu, prevMenu));
        return panel;
    }

    private static String getSection(DnDableTabbedPane tabbedPane) {
        if (tabbedPane.getSelectedIndex() == -1) {
            return null;
        }
        return tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
    }

    private static class RemoveListener
    implements ActionListener {
        private final ChartPanel panel;

        RemoveListener(ChartPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            block5: {
                DnDableTabbedPane tabbedPane = (DnDableTabbedPane)this.panel.getParent();
                String section = ChartUtil.getSection(tabbedPane);
                if (section == null) {
                    return;
                }
                int r = JOptionPane.showConfirmDialog(tabbedPane, MessageResource.ConfirmDialog.getRemoveSectionMessage(section), "\u30bb\u30af\u30b7\u30e7\u30f3\u306e\u524a\u9664 - Marimite", 2);
                if (r != 0) {
                    return;
                }
                try {
                    this.removeImpl(JmxRemote.getConnection(), tabbedPane);
                }
                catch (Exception e) {
                    JmxRemote.notifyLostConnection();
                    if (tabbedPane.getSelectedIndex() == -1) {
                        return;
                    }
                    Icon icon = ImageResource.getCrossIcon();
                    int index = tabbedPane.getSelectedIndex();
                    if (tabbedPane.getIconAt(index) == icon) break block5;
                    tabbedPane.setIconAt(index, icon);
                    tabbedPane.setToolTipTextAt(index, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306b\u30a8\u30e9\u30fc");
                    tabbedPane.repaint();
                }
            }
        }

        private void removeImpl(MBeanServerConnection connection, DnDableTabbedPane tabbedPane) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
            int selectedTabIdx = tabbedPane.getSelectedIndex();
            Object[] params = new Object[]{tabbedPane.getTitleAt(selectedTabIdx)};
            String[] signature = new String[]{"java.lang.String"};
            connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "removeSection", params, signature);
            connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "removeSection", params, signature);
            tabbedPane.remove(selectedTabIdx);
            if (tabbedPane.getTabCount() == 0) {
                tabbedPane.getRootWindow().dispose();
            }
        }
    }

    private static class NavSectionListener
    implements ActionListener {
        private final ChartPanel panel;
        private final String section;

        public NavSectionListener(ChartPanel panel, String section) {
            this.panel = panel;
            this.section = section;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DnDableTabbedPane tabbedPane = Updater.getViewingTabbedPane(this.section);
            if (tabbedPane == null) {
                tabbedPane = (DnDableTabbedPane)this.panel.getParent();
                tabbedPane.addTab(this.section, null, (Component)ChartUtil.getChartPanel(), null);
            }
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                if (!tabbedPane.getTitleAt(i).equals(this.section)) continue;
                tabbedPane.setSelectedIndex(i);
                tabbedPane.getRootWindow().requestFocus();
                return;
            }
        }
    }

    private static class BuildNavigationListener
    implements PopupMenuListener {
        private final ChartPanel panel;
        private final JMenu nextMenu;
        private final JMenu prevMenu;

        public BuildNavigationListener(ChartPanel panel, JMenu nextMenu, JMenu prevMenu) {
            this.panel = panel;
            this.nextMenu = nextMenu;
            this.prevMenu = prevMenu;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            try {
                this.buildImpl();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void buildImpl() throws IOException, ReflectionException, InstanceNotFoundException {
            DnDableTabbedPane tabbedPane = (DnDableTabbedPane)this.panel.getParent();
            String section = ChartUtil.getSection(tabbedPane);
            if (section == null) {
                return;
            }
            String rightCP = section.split(" - ")[1];
            String starts = rightCP + " - ";
            String leftCP = section.split(" - ")[0];
            String ends = " - " + leftCP;
            HashSet<String> sectionSet = new HashSet<String>();
            for (String s : JmxRemote.getLogSectionSet()) {
                sectionSet.add(s);
            }
            for (String s : JmxRemote.getLiveSectionSet()) {
                sectionSet.add(s);
            }
            ArrayList<String> nextSectionList = new ArrayList<String>();
            ArrayList<String> prevSectionList = new ArrayList<String>();
            for (String s : sectionSet) {
                if (s.startsWith(starts)) {
                    nextSectionList.add(s);
                }
                if (!s.endsWith(ends)) continue;
                prevSectionList.add(s);
            }
            this.buildSectionItem(leftCP, prevSectionList, this.prevMenu);
            this.buildSectionItem(rightCP, nextSectionList, this.nextMenu);
        }

        private void buildSectionItem(String checkPoint, List<String> sectionList, JMenu menu) {
            Collections.sort(sectionList);
            menu.removeAll();
            for (String s : sectionList) {
                JMenuItem item = new JMenuItem(s.replace(checkPoint, ""));
                item.addActionListener(new NavSectionListener(this.panel, s));
                menu.add(item);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

