/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

/**
 *
 * @author NAKAZATO Hajime
 */
public class ChartUtil {

    public static ChartPanel getChartPanel() {
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        DateLogAxis xAxis = new DateLogAxis();
        xAxis.setInverted(true);
        NumberAxis yAxis = new NumberAxis();
        DeviationRenderer renderer = new DeviationRenderer(true, true);
        renderer.setAlpha(0.2f);
        renderer.setSeriesPaint(0, Color.BLUE);
        renderer.setSeriesPaint(1, Color.RED);
        renderer.setSeriesPaint(2, Color.GREEN);
        renderer.setSeriesFillPaint(0, renderer.getSeriesPaint(0));
        renderer.setSeriesFillPaint(1, renderer.getSeriesPaint(1));
        renderer.setSeriesFillPaint(2, renderer.getSeriesPaint(2));
        renderer.setBaseToolTipGenerator(new ToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        XYLineAndShapeRenderer sr = new XYLineAndShapeRenderer(false, true);
        sr.setSeriesPaint(0, Color.YELLOW);
        plot.setRenderer(1, sr);
        plot.setBackgroundPaint(Color.LIGHT_GRAY);
        JFreeChart chart = new JFreeChart(null,
                UIManager.getFont("Label.font"),
                plot,
                true);
        ChartPanel panel = new ChartPanel(chart);

        JPopupMenu pm = panel.getPopupMenu();
        pm.addSeparator();
        JMenuItem removeMenu = new JMenuItem(MessageResource.ContextMenu.REMOVE_SECTION);
        removeMenu.addActionListener(new RemoveListener(panel));
        pm.add(removeMenu);

        pm.insert(new JPopupMenu.Separator(), 0);
        JMenu nextMenu = new JMenu(MessageResource.ContextMenu.NAV_NEXT);
        pm.insert(nextMenu, 0);
        JMenu prevMenu = new JMenu(MessageResource.ContextMenu.NAV_PREV);
        pm.insert(prevMenu, 0);
        pm.addPopupMenuListener(new BuildNavigationListener(panel, nextMenu, prevMenu));

        return panel;
    }

    private static String getSection(DnDableTabbedPane tabbedPane) {
        if (tabbedPane.getSelectedIndex() == -1) {
            return null;
        }
        return tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
    }

    private static class BuildNavigationListener implements PopupMenuListener {

        private final ChartPanel panel;
        private final JMenu nextMenu;
        private final JMenu prevMenu;

        public BuildNavigationListener(ChartPanel panel, JMenu nextMenu, JMenu prevMenu) {
            this.panel = panel;
            this.nextMenu = nextMenu;
            this.prevMenu = prevMenu;
        }
        
        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            try {
                buildImpl();
            } catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void buildImpl() throws IOException, ReflectionException, InstanceNotFoundException {
            DnDableTabbedPane tabbedPane = (DnDableTabbedPane) panel.getParent();
            String section = getSection(tabbedPane);
            if (section == null) {
                return;
            }
            String rightCP = section.split(" - ")[1];
            String starts = rightCP + " - ";
            String leftCP = section.split(" - ")[0];
            String ends = " - " + leftCP;

            Set<String> sectionSet = new HashSet<String>();
            for (String s : JmxRemote.getLogSectionSet()) {
                sectionSet.add(s);
            }
            for (String s : JmxRemote.getLiveSectionSet()) {
                sectionSet.add(s);
            }
            
            List<String> nextSectionList = new ArrayList<String>();
            List<String> prevSectionList = new ArrayList<String>();
            for (String s : sectionSet) {
                if (s.startsWith(starts)) {
                    nextSectionList.add(s);
                }
                if (s.endsWith(ends)) {
                    prevSectionList.add(s);
                }
            }
            buildSectionItem(leftCP, prevSectionList, prevMenu);
            buildSectionItem(rightCP, nextSectionList, nextMenu);
        }

        private void buildSectionItem(String checkPoint, List<String> sectionList, JMenu menu) {
            Collections.sort(sectionList);
            menu.removeAll();
            for (String s : sectionList) {
                JMenuItem item = new JMenuItem(s.replace(checkPoint, ""));
                item.addActionListener(new NavSectionListener(panel, s));
                menu.add(item);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
        
    }

    private static class NavSectionListener implements ActionListener {

        private final ChartPanel panel;
        private final String section;

        public NavSectionListener(ChartPanel panel, String section) {
            this.panel = panel;
            this.section = section;
        }
        
        @Override
        public void actionPerformed(ActionEvent ae) {
            DnDableTabbedPane tabbedPane = Updater.getViewingTabbedPane(section);
            if (tabbedPane == null) {
                tabbedPane = (DnDableTabbedPane) panel.getParent();
                tabbedPane.addTab(section, null, ChartUtil.getChartPanel(), null);
            }
            for (int i = 0; i < tabbedPane.getTabCount(); i++) {
                if (tabbedPane.getTitleAt(i).equals(section)) {
                    tabbedPane.setSelectedIndex(i);
                    tabbedPane.getRootWindow().requestFocus();
                    return;
                }
            }
        }
    }

    private static class RemoveListener implements ActionListener {

        private final ChartPanel panel;

        RemoveListener(ChartPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DnDableTabbedPane tabbedPane = (DnDableTabbedPane) panel.getParent();
            String section = getSection(tabbedPane);
            if (section == null) {
                return;
            }
            int r = JOptionPane.showConfirmDialog(tabbedPane,
                    MessageResource.ConfirmDialog.getRemoveSectionMessage(section),
                    MessageResource.ConfirmDialog.REMOVE_SECTION_TITLE,
                    JOptionPane.OK_CANCEL_OPTION);
            if (r != JOptionPane.OK_OPTION) {
                return;
            }

            try {
                removeImpl(JmxRemote.getConnection(), tabbedPane);
            } catch (Exception e) {
                JmxRemote.notifyLostConnection();
                if (tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                Icon icon = ImageResource.getCrossIcon();
                int index = tabbedPane.getSelectedIndex();
                if (tabbedPane.getIconAt(index) != icon) {
                    tabbedPane.setIconAt(index, icon);
                    tabbedPane.setToolTipTextAt(index, MessageResource.TabToolTip.NO_CONNECTION);
                    tabbedPane.repaint();
                }
            }
        }

        private void removeImpl(MBeanServerConnection connection, DnDableTabbedPane tabbedPane) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
            int selectedTabIdx = tabbedPane.getSelectedIndex();
            Object[] params = {tabbedPane.getTitleAt(selectedTabIdx)};
            String[] signature = {"java.lang.String"};
            connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "removeSection", params, signature);
            connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "removeSection", params, signature);

            tabbedPane.remove(selectedTabIdx);
            if (tabbedPane.getTabCount() == 0) {
                tabbedPane.getRootWindow().dispose();
            }
        }
    }
}
