/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.chart;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

/**
 *
 * @author NAKAZATO Hajime
 */
public class Updater implements DnDableTabbedPane.Updater {

    private static final Set<Updater> INSTANCE_SET = new CopyOnWriteArraySet<Updater>();
    private final DnDableTabbedPane tabbedPane;

    public Updater(DnDableTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        INSTANCE_SET.add(this);
    }

    public static void updateAll() {
        for (Updater u : INSTANCE_SET) {
            u.update();
        }
    }

    private void updateImpl(MBeanServerConnection connection) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        int selectedIndex = tabbedPane.getSelectedIndex();
        String section = tabbedPane.getTitleAt(selectedIndex);
        ChartPanel chartPanel = (ChartPanel) tabbedPane.getSelectedComponent();
        XYPlot plot = (XYPlot) chartPanel.getChart().getPlot();

        Object[] params = {section};
        String[] signature = {"java.lang.String"};
        Map<Long, Double[]> logLap = (Map<Long, Double[]>) connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "getLog", params, signature);
        if (logLap != null) {
            XYIntervalSeries medSeries = new XYIntervalSeries(MessageResource.Legend.MEDIAN);
            XYIntervalSeries tailSeries = new XYIntervalSeries(MessageResource.Legend.TAIL);
            XYIntervalSeries worstSeries = new XYIntervalSeries(MessageResource.Legend.WORST);
            long current = System.currentTimeMillis();
            ToolTipGenerator ttg = (ToolTipGenerator) plot.getRenderer().getBaseToolTipGenerator();
            ttg.setCurrent(current);
            for (Map.Entry<Long, Double[]> me : logLap.entrySet()) {
                long t = current - me.getKey();
                if (t < 50) {
                    t = 50;
                }
                Double[] v = me.getValue();
                double med = v[0];
                double medSD = Math.pow(v[1], 0.5);
                double tail = v[2];
                double tailSD = Math.pow(v[3], 0.5);
                double worst = v[4];
                double worstSD = Math.pow(v[5], 0.5);

                medSeries.add(t, t, t, med, med - medSD, med + medSD);
                tailSeries.add(t, t, t, tail, tail - tailSD, tail + tailSD);
                worstSeries.add(t, t, t, worst, worst - worstSD, worst + worstSD);
            }
            XYIntervalSeriesCollection logDS = new XYIntervalSeriesCollection();
            logDS.addSeries(medSeries);
            logDS.addSeries(tailSeries);
            logDS.addSeries(worstSeries);
            plot.setDataset(logDS);
        }
        plot.getDomainAxis().setAutoRange(true);
        plot.getDomainAxis().setLowerBound(900);

        Long[] liveLap = (Long[]) connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "getLap", params, signature);
        if (liveLap != null) {
            XYSeries liveSeries = new XYSeries(MessageResource.Legend.LIVE);
            for (long l : liveLap) {
                liveSeries.add(1000, l);
            }
            XYSeriesCollection liveDS = new XYSeriesCollection();
            liveDS.addSeries(liveSeries);
            plot.setDataset(1, liveDS);
        }

        String toolTip = null;
        Icon icon = null;
        if (logLap == null) {
            if (liveLap == null) {
                icon = ImageResource.getExclamationIcon();
                toolTip = MessageResource.TabToolTip.NO_SECTION;
            } else {
                icon = ImageResource.getInfoIcon();
                toolTip = MessageResource.TabToolTip.NO_LOG;
            }
        } else {
            if (liveLap == null) {
                icon = ImageResource.getWarnIcon();
                toolTip = MessageResource.TabToolTip.NO_LIVE;
            } else {
                icon = null;
                toolTip = null;
            }
        }
        setStatusAt(selectedIndex, icon, toolTip);

        chartPanel.repaint();
    }

    private void setStatusAt(int index, Icon icon, String toolTip) {
        if (tabbedPane.getIconAt(index) != icon) {
            tabbedPane.setIconAt(index, icon);
            tabbedPane.setToolTipTextAt(index, toolTip);
            tabbedPane.repaint();
        }
    }

    public void update() {
        if (!(tabbedPane.getSelectedComponent() instanceof ChartPanel)) {
            return;
        }
        if (tabbedPane.getSelectedIndex() == -1) {
            return;
        }

        try {
            updateImpl(JmxRemote.getConnection());
        } catch (Exception e) {
            JmxRemote.notifyLostConnection();
            if (tabbedPane.getSelectedIndex() == -1) {
                return;
            }
            setStatusAt(tabbedPane.getSelectedIndex(), ImageResource.getCrossIcon(), MessageResource.TabToolTip.NO_CONNECTION);
        }
    }

    @Override
    public void dispose() {
        INSTANCE_SET.remove(this);
    }

    public static Set<String> getAllViewingSectionSet() {
        Set<String> r = new HashSet<String>();
        for (Updater u : INSTANCE_SET) {
            for (int i = 0; i < u.tabbedPane.getTabCount(); i++) {
                r.add(u.tabbedPane.getTitleAt(i));
            }
        }
        return r;
    }

    public static DnDableTabbedPane getViewingTabbedPane(String section) {
        for (Updater u : INSTANCE_SET) {
            for (int i = 0; i < u.tabbedPane.getTabCount(); i++) {
                if (u.tabbedPane.getTitleAt(i).equals(section)) {
                    return u.tabbedPane;
                }
            }
        }
        return null;
    }
}
