/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.xml.sax.Attributes;

public abstract class MappingAction {
    public static final MappingAction EMPTY = new Base();
    public static final MappingAction IGNORE = new Ignore();

    public abstract MappingAction next(String var1, String var2, Attributes var3, ReadContext var4) throws Exception;

    public abstract MappingAction begin(String var1, String var2, Attributes var3, ReadContext var4) throws Exception;

    public abstract void body(String var1, ReadContext var2) throws Exception;

    public abstract void end(ReadContext var1) throws Exception;

    public static class Base
    extends MappingAction {
        public MappingAction next(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            return context.getActionMappingStrategy().getMappingAction(namespace, name, attributes, context);
        }

        public MappingAction begin(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            ElementDescriptor descriptor = context.getCurrentDescriptor();
            if (descriptor != null) {
                AttributeDescriptor[] attributeDescriptors = descriptor.getAttributeDescriptors();
                context.populateAttributes(attributeDescriptors, attributes);
            }
            return this;
        }

        public void body(String text, ReadContext context) throws Exception {
        }

        public void end(ReadContext context) throws Exception {
            context.popElement();
        }
    }

    private static final class Ignore
    extends MappingAction {
        private Ignore() {
        }

        public MappingAction next(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            return this;
        }

        public MappingAction begin(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            return this;
        }

        public void body(String text, ReadContext context) throws Exception {
        }

        public void end(ReadContext context) throws Exception {
        }
    }
}

