/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.core.event.Target;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;


public class MessageSchemaValueSuppressionStrategy extends ValueSuppressionStrategy {
	
	/**the value of the static var FLAG_XXX_XXX is get from xsdConfig.betwixt*/
	private static final String FLAG_SOURCE = "flagSource";
	
	private static final String FLAG_SOURCE_NODE_CHILDNODE_NOT_NULL = "flagSourceNodeAndChildNodeAreNotNull";
	
	private static final String FLAG_SOURCE_NODE_NOT_NULL_CHILDNODE_NULL = "flagSourceNodeIsNotNullChildNodeIsNull";
	
	private static final String FLAG_SOURCE_NODE_NULL_CHILDNODE_NOT_NULL = "flagSourceNodeIsNullChildNodeIsNotNull";
	
	private static final String FLAG_TARGET = "flagTarget";
	
	private static final String FLAG_TARGET_IN_INKEY_NOT_NULL = "flagTargetInIsNotNullInkeyIsNotNull";
	
	private static final String FLAG_TARGET_IN_NULL_INKEY_NOT_NULL = "flagTargetInIsNullInkeyIsNotNull";

	private MaskatElement maskatElement = null;
	
	private ElementDescriptor currentElement = null;
	
	public MessageSchemaValueSuppressionStrategy() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.commons.betwixt.strategy.ValueSuppressionStrategy#suppressAttribute(org.apache.commons.betwixt.AttributeDescriptor,
	 *      java.lang.String)
	 */
	public boolean suppressAttribute(AttributeDescriptor attributeDescriptor, String value) {
		String attributeName = attributeDescriptor.getQualifiedName();
		String propertyName =  attributeDescriptor.getPropertyName();
		
		if (isFlagAttribute(attributeName)) {
			return true;
		}
		
		if (maskatElement != null) {
			if (maskatElement instanceof Source && usedFor(currentElement, FLAG_SOURCE)) {
				Source source = (Source) maskatElement;
				if ("name".equals(attributeName) && "node".equals(propertyName)) {
					return source.getNode() == null && source.getChildNode() != null;
				}
				if ("type".equals(attributeName) && "xsd:string".equals(value)) {
					return source.getBinds().length > 0;
				}
				if ("name".equals(attributeName) && "childNode".equals(propertyName)) {
					if (source.getNode() != null) {
						return source.getChildNode() == null ||
								source.getBinds().length > 0;
					}
				}
				if ("maxOccurs".equals(attributeName)) {
					return !(source.getBinds().length > 0 &&
							source.getChildNode() != null &&
							source.getNode() == null);
				}
			}
			if (maskatElement instanceof Target && usedFor(currentElement, FLAG_TARGET)) {
				Target target = (Target) maskatElement;
				if ("name".equals(attributeName) && "in".equals(propertyName)) {
					return target.getIn() == null&& target.getInkey() != null;
				}
				if ("type".equals(attributeName) && "xsd:string".equals(value)) {
					return target.getBinds().length > 0;
				}
				if ("name".equals(attributeName) && "inkey".equals(propertyName)) {
					return target.getIn() != null || !(target.getBinds().length > 0);
				}
				if ("maxOccurs".equals(attributeName)) {
					return !(target.getBinds().length > 0 &&
							target.getInkey() != null &&
							target.getIn() == null);
				}
			}
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.commons.betwixt.strategy.ValueSuppressionStrategy#suppressElement(org.apache.commons.betwixt.ElementDescriptor,
	 *      java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.Object)
	 */
	public boolean suppressElement(ElementDescriptor element, String namespaceUri,
			String localName, String qualifiedName, Object value) {
		if (value instanceof MaskatElement) {
			maskatElement = (MaskatElement)value;
		}
		currentElement = element;
		
		if (value instanceof Source) {
			Source source = (Source) value;
			if (source.getBinds().length <= 0) {
				return usedFor(element, FLAG_SOURCE_NODE_CHILDNODE_NOT_NULL)
						|| usedFor(element, FLAG_SOURCE_NODE_NOT_NULL_CHILDNODE_NULL)
						|| usedFor(element, FLAG_SOURCE_NODE_NULL_CHILDNODE_NOT_NULL);
			}
			
			if (source.getChildNode() == null && source.getNode() != null) {
				return usedFor(element, FLAG_SOURCE_NODE_CHILDNODE_NOT_NULL)
						|| usedFor(element, FLAG_SOURCE_NODE_NULL_CHILDNODE_NOT_NULL);
			}

			if (source.getChildNode() != null && source.getNode() == null) {
				return usedFor(element, FLAG_SOURCE_NODE_CHILDNODE_NOT_NULL)
						|| usedFor(element, FLAG_SOURCE_NODE_NOT_NULL_CHILDNODE_NULL);
			}
			
			if (source.getChildNode() != null && source.getNode() != null) {
				return usedFor(element, FLAG_SOURCE_NODE_NULL_CHILDNODE_NOT_NULL)
						|| usedFor(element, FLAG_SOURCE_NODE_NOT_NULL_CHILDNODE_NULL);
			}

		}
		if (value instanceof Target) {
			Target target = (Target) value;
			if (target.getBinds().length <= 0) {
				return usedFor(element, FLAG_TARGET_IN_INKEY_NOT_NULL)
					|| usedFor(element, FLAG_TARGET_IN_NULL_INKEY_NOT_NULL);
			}
			
			if (target.getIn() != null) {
				return usedFor(element, FLAG_TARGET_IN_NULL_INKEY_NOT_NULL);
			}
			
			if (target.getIn() == null) {
				return usedFor(element, FLAG_TARGET_IN_INKEY_NOT_NULL);
			}
		}
		return false;
	}
	
	private boolean isFlagAttribute(String flagAttribute) {
		return FLAG_SOURCE.equals(flagAttribute)
			|| FLAG_SOURCE_NODE_CHILDNODE_NOT_NULL.equals(flagAttribute)
			|| FLAG_SOURCE_NODE_NOT_NULL_CHILDNODE_NULL.equals(flagAttribute)
			|| FLAG_SOURCE_NODE_NULL_CHILDNODE_NOT_NULL.equals(flagAttribute)
			|| FLAG_TARGET.equals(flagAttribute)
			|| FLAG_TARGET_IN_INKEY_NOT_NULL.equals(flagAttribute)
			|| FLAG_TARGET_IN_NULL_INKEY_NOT_NULL.equals(flagAttribute)
			;
	}
	
	private boolean usedFor(ElementDescriptor element, String flagAttribute) {
		return element.getAttributeDescriptors().length > 0
			&& element.getAttributeDescriptor(flagAttribute) != null;
	}

}
