/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.core.event.Target;


public abstract class AbstractComponent extends AbstractLayoutElement
		implements Component {

	private String name;

	private int tabIndex;

	private int left;

	private int top;

	private int width;

	private int height;

	/** モデルの状態変化を通知するリスナのリスト */
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public AbstractComponent() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getName()
	 */
	public String getName() {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setName(java.lang.String)
	 */
	public void setName(String name) {
		String oldName = this.name;
		this.name = name;
		updateComponentIdInEvent(oldName, name);
		firePropertyChange("name", oldName, name);
	}

	public int getTabIndex() {
		return tabIndex;
	}

	public void setTabIndex(int tabIndex) {
		this.tabIndex = tabIndex;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setHeight(int)
	 */
	public void setHeight(int height) {
		int oldHeight = this.height;
		this.height = height;
		if (oldHeight != height) {
			firePropertyChange("constraint", "", null);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getLeft()
	 */
	public int getLeft() {
		return left;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setLeft(int)
	 */
	public void setLeft(int left) {
		int oldLeft = this.left;
		this.left = left;
		if (oldLeft != left) {
			firePropertyChange("constraint", "", null);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getTop()
	 */
	public int getTop() {
		return top;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setTop(int)
	 */
	public void setTop(int top) {
		int oldTop = this.top;
		this.top = top;
		if (oldTop != top) {
			firePropertyChange("constraint", "", null);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setWidth(int)
	 */
	public void setWidth(int width) {
		int oldWidth = this.width;
		this.width = width;
		if (oldWidth != width) {
			firePropertyChange("constraint", "", null);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#setConstraint(int, int,
	 *      int, int)
	 */
	public void setConstraint(int left, int top, int width, int height) {
		this.left = left;
		this.top = top;
		this.width = width;
		this.height = height;
		firePropertyChange("constraint", "", null);
	}

	private List javaScripts = new ArrayList();
	public void addJavaScript(String content) {
		JavaScript javascriptDef = new JavaScript();
		javascriptDef.setContent(content);
		javaScripts.add(javascriptDef);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.framework.screendef.IComponentDef#getParent()
	 */
	public Component getContainer() {
		if (getParent() instanceof Component) {
			return (Component) getParent();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.core.layout.IComponent#getEventTypes()
	 */
	public String[] getEventTypes() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.core.layout.IComponent#hasEvent(java.lang.String)
	 */
	public boolean hasEvent(String eventType) {
		String[] eventTypes = getEventTypes();
		if (eventTypes != null && eventTypes.length > 0) {
			for (int i = 0; i < eventTypes.length; i++) {
				if (eventTypes[i].equals(eventType)) {
					return true;
				}
			}
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.core.layout.Component#getEvent(java.lang.String)
	 */
	public Event getEvent(String eventType) {
		if (hasEvent(eventType)) {
			EventDef eventDef = getLayout().getLayoutDef().getEventDef();

			jp.sf.maskat.core.event.Component component = eventDef.findComponent(getName());
			if (component != null) {
				return component.findEvent(eventType);
			}
		}
		return null;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.core.layout.Component#setEvent(Evnet)
	 */
	public void setEvent(Event event) {
		if (hasEvent(event.getId())) {
			EventDef eventDef = getLayout().getLayoutDef().getEventDef();
			jp.sf.maskat.core.event.Component component = eventDef.findComponent(getName());
			if (component == null) {
				component = new jp.sf.maskat.core.event.Component();
				component.setId(getName());
				eventDef.addChild(component);
			}
			component.setEvent(event);
			firePropertyChange("#event", null, event);
		}
	}
	
	public void addPropertyChangeListener(PropertyChangeListener l) {
		listeners.addPropertyChangeListener(l);
	}

	public void firePropertyChange(String propName, Object oldValue, Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener l) {
		listeners.removePropertyChangeListener(l);
	}

	public Object clone() throws CloneNotSupportedException {
		AbstractComponent def = (AbstractComponent) super.clone();
		def.listeners = new PropertyChangeSupport(def);
		return def;
	}
	
	private void updateComponentIdInEvent(String oldId, String newId) {
		if (oldId == null || oldId.equals(newId)) {
			return;
		}
		if (getLayout() == null || getLayout().getLayoutDef() == null
				|| getLayout().getLayoutDef().getEventDef() == null) {
			return;
		}
		
		EventDef eventDef = getLayout().getLayoutDef().getEventDef();
		jp.sf.maskat.core.event.Component component = eventDef.findComponent(oldId);
		if (component != null) {
			component.setId(newId);
		}
		
		//TODO should update all Source.obj , Source.idxRef, Target.in, Target.out who equals to oldId ?
		List sources = getAllDescendants(eventDef, Source.class);
		for (int i=0; i<sources.size(); i++) {
			Source source = (Source)sources.get(i);
			if (oldId.equals(source.getObj())) {
				source.setObj(newId);
			}
			if (oldId.equals(source.getIdxRef())) {
				source.setIdxRef(newId);
			}
		}
		List targets = getAllDescendants(eventDef, Target.class);
		for (int i=0; i<targets.size(); i++) {
			Target target = (Target)targets.get(i);
			if (oldId.equals(target.getIn())) {
				target.setIn(newId);
			}
			if (oldId.equals(target.getOut())) {
				target.setOut(newId);
			}
		}
	}

}
