/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.util.HashMap;
import java.util.Map;

public class ComponentLibrary {
	
	private String prefix;

	private String namespaceURI;
	
	private boolean isDefault;

	/**
	 * Map of the configuration of customized component. key is component node
	 * name. value is one IComponentPluginConfig.
	 */
	private Map types;

	public ComponentLibrary(String prefix, String namespaceURI, boolean isDefault) {
		super();
		this.prefix = prefix;
		this.namespaceURI = namespaceURI;
		this.isDefault = isDefault;
	}

	public String getPrefix() {
		return prefix;
	}

	public String getNamespaceURI() {
		return namespaceURI;
	}

	public boolean isDefault() {
		return isDefault;
	}

	public void setDefault(boolean isDefault) {
		this.isDefault = isDefault;
	}

	public Object getComponentType(String name) {
		if (types == null || !types.containsKey(name)) {
			return null;
		}
		return types.get(name);
	}
	
	public boolean containsComponent(String name) {
		return !(types == null || !types.containsKey(name));
	}

	public Object[] getComponentTypes() {
		return types.values().toArray();
	}

	public void registerComponentType(String name, Object type) {
		if (types == null) {
			types = new HashMap();
		}
		types.put(name, type);
	}

}
