/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

public class DynaProperty extends org.apache.commons.beanutils.DynaProperty {

	private static final long serialVersionUID = -7320819120407974204L;

	private String[] items;
	
	private boolean  required;
	
	private boolean cdataSection;
	
	private boolean editable = true;
	
	private boolean enabled = true;


	public DynaProperty(String name, Class type, boolean enabled) {
		super(name, type);
		this.enabled = enabled;
	}
	
	public DynaProperty(String name, Class type, Class contentType) {
		super(name, type, contentType);
	}

	public DynaProperty(String name, Class type) {
		super(name, type);
	}

	public DynaProperty(String name) {
		super(name);
	}

	public String[] getItems() {
		return items;
	}

	public void setItems(String[] items) {
		this.items = items;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public boolean isCdataSection() {
		return cdataSection;
	}

	public void setCdataSection(boolean cdataSection) {
		this.cdataSection = cdataSection;
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
}
