/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;

public class Layout extends AbstractContainer {

	private LayoutDef layoutDef;

//	private List children = new ArrayList();
	
	public LayoutDef getLayoutDef() {
		return layoutDef;
	}

	public void setLayoutDef(LayoutDef layoutDef) {
		this.layoutDef = layoutDef;
	}

//	public void addChild(Object element) {
//		super.addChild(element);
//		if (element instanceof LayoutDef) {
//			layoutDef = (LayoutDef) element;
//		}
//	}
//	
//	public void removeChild(Object obj) {
//		children.remove(obj);
//	}

//	public List getChildren() {
//		return children;
//	}

	public Layout getLayout() {
		return this;
	}

	public String[] getEventTypes() {
		return new String[] {"onload", "onunload", "onshow", "onhide"};
	}

	public Event getEvent(String eventType) {
		if (hasEvent(eventType)) {
			EventDef eventDef = getLayout().getLayoutDef().getEventDef();
			Event event = eventDef.findEvent(eventType);
			if (event == null) {
				event = new Event(eventType);
				eventDef.addChild(event);
			}
			return event;
		}
		return null;
	}
}
