/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

/**
 * Thrown when a component or a attribute undefined by the plugin is requested.
 */
public class UnknownComponentException extends Exception {

	private static final long serialVersionUID = -1699133230356696955L;

	public UnknownComponentException() {
		super();
	}

	public UnknownComponentException(String message, Throwable cause) {
		super(message, cause);
	}

	public UnknownComponentException(String message) {
		super(message);
	}

	public UnknownComponentException(Throwable cause) {
		super(cause);
	}

}
