/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutDef;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;

import org.eclipse.gef.commands.Command;


public class AddBasicDefCommand extends Command {

	private MaskatElement parent;

	private MaskatElement child;

	private MaskatElement originalParent;

	private int originalIdx;

	private boolean addedPrefixMapping;
	
	public AddBasicDefCommand(MaskatElement parent, MaskatElement child) {
		super(Messages.getString("layout.cmd.add.msg.title")); //$NON-NLS-1$
		this.parent = parent;
		this.child = child;
		this.addedPrefixMapping = false;
	}

	public void execute() {
		originalParent = child.getParent();
		if (originalParent != null) {
			originalIdx = originalParent.getChildIdx(child);
	
			if (originalIdx == -1) {
				// childはoriginalParentの子ノードではない
				originalParent = null;
			} else {
				// childはoriginalParentの子ノードだ
				originalParent.removeChild(child);
			}
		} else {
			Layout layout = ((Component) parent).getLayout();
			ComponentUtils.setUniqueName(layout, (Component) child);
		}
		parent.addChild(child);
		
		if (child instanceof DynaComponent) {
			LayoutDef layoutDef = ((DynaComponent) child).getLayout().getLayoutDef();

			DynaComponent dynaComponent = (DynaComponent) child;
			DynaComponentClass dynaClass = (DynaComponentClass) dynaComponent
					.getDynaClass();
			ComponentLibrary library = dynaClass.getLibrary();
			String namespace = library.getNamespaceURI();
			String prefix = library.getPrefix();
			if (namespace == null || "".equals(namespace)) {
				addedPrefixMapping = false;
			} else if (!layoutDef.getNamespaces().containsKey(namespace)) {
				layoutDef.getNamespaces().put(namespace, prefix);
				addedPrefixMapping = true;
			}
		}
	}

	public void undo() {
		parent.removeChild(child);
		if (originalParent != null) {
			originalParent.addChildToIdx(child, originalIdx);
		}
		if (child instanceof DynaComponent && addedPrefixMapping) {
			DynaComponent dynaBean = (DynaComponent) child;
			DynaComponentClass dynaClass = (DynaComponentClass) dynaBean.getDynaClass();

			String namespaceURI = dynaClass.getLibrary().getNamespaceURI();
			LayoutDef layoutDef = dynaBean.getLayout().getLayoutDef();
			layoutDef.getNamespaces().remove(namespaceURI);
		}
	}

	public boolean canUndo() {
		return true;
	}
}
