/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.commands;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.Messages;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;


public class ChangeGridHeaderWidthCommand extends Command {
	
	private Component gridHeader;

	private int newWidth;
	
	private int oldWidth;

	public ChangeGridHeaderWidthCommand(Component node, Rectangle newConstraint) {
		super(Messages.getString("layout.cmd.gridheader.width.msg")); //$NON-NLS-1$
		gridHeader = node;
		newWidth = newConstraint.width;
		oldWidth = gridHeader.getWidth();
	}

	public boolean canExecute() {
		return newWidth != oldWidth;
	}

	public void execute() {
		gridHeader.setWidth(newWidth);
		super.execute();
	}

	public boolean canUndo() {
		return true;
	}

	public void undo() {
		gridHeader.setWidth(oldWidth);
		super.undo();
	}
}
