/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.commands;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.Messages;

import org.eclipse.gef.commands.Command;


public class DelComboItemCommand extends Command {

	private Component parent;

	private Component component;

	private int idx;

	public DelComboItemCommand(Component parent, Component child) {
		super(Messages.getString("layout.cmd.remove.comboitem.msg")); //$NON-NLS-1$
		this.parent = parent;
		this.component = child;
	}

	public void execute() {
		idx = parent.getChildIdx(component);
		if (idx == -1) {
			throw new IllegalStateException(
					"The comboitem is not a child of the combobox.");
		}
		parent.removeChild(component);
	}

	public void undo() {
		parent.addChildToIdx(component, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
