/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.commands.ChangeConstraintCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.widget.rialto.editpolicy.SplitterLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.figure.SplitterFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;


public class SplitterEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	private DivSplitEditPart firstPart = null;
	private DivSplitEditPart secondPart = null;	
	private SplitLineEditPart lineEditPart = null;
	
	protected IFigure createFigure() {
		return new SplitterFigure();
	}
	
	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				comp.getWidth(), comp.getHeight());
		GraphicalEditPart parent = (GraphicalEditPart) getParent();
		if (parent != null) {
			parent.setLayoutConstraint(this, getFigure(),
				constraint);
		}
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
		
	private SplitLineEditPart getSplitLineEditPart() {
		if (lineEditPart == null) {
			lineEditPart = new SplitLineEditPart(getModel());
		}
		return lineEditPart;
	}

	protected void refreshChildren() {
		super.refreshChildren();
		addChild(getSplitLineEditPart(), -1);
		
		if (firstPart == null) {
			List children = getChildren();
			for (int i = 0; i < children.size(); i++) {
				Object obj = children.get(i);
				if (obj instanceof DivSplitEditPart) {
					if (firstPart == null) {
						firstPart = (DivSplitEditPart) obj;
						firstPart.setIndex(0);
						firstPart.refreshVisuals();
						
					} else {
						secondPart = (DivSplitEditPart) obj;
						secondPart.setIndex(1);
						secondPart.refreshVisuals();
					}
				}
			}
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("prop".equals(evt.getPropertyName()) ||
				"orientation".equals(evt.getPropertyName())) {
			refreshVisuals();
			setDivSplitVisible(true);
			refreshDivSplites();
			getViewer().select(this);
		} else if ("constraint".equals(evt.getPropertyName())) {
			refreshDivSplites();
		} else if ("width".equals(evt.getPropertyName())) {
			refreshDivSplites();
		} else if ("height".equals(evt.getPropertyName())) {
			refreshDivSplites();
		}
		super.propertyChange(evt);
	}

	public void setDivSplitVisible(boolean visible) {
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			Object obj = children.get(i);
			if (obj instanceof DivSplitEditPart) {
				((DivSplitEditPart) obj).getFigure().setVisible(visible);
			}
		}		
	}
	
	public void refreshSelectedWidget(ComponentEditPart child) {
		if (getParent() instanceof ComponentEditPart) {
			((ComponentEditPart) getParent()).refreshSelectedWidget(this);
		}
		refreshVisuals();
	}	

	protected void createEditPolicies() {
		super.createEditPolicies();
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new SplitterLayoutEditPolicy(style));
	}	
	
	public Command createConstrainCommand(Object model, Rectangle constraint) {
		if (model instanceof Component) {
			return  new ChangeConstraintCommand((Component) model, constraint);
		} else if (model == SplitLineEditPart.SPLITLINE_MODEL) {
			return  new ChangeConstraintCommand((Component) model, constraint);
		}
		return null;
	}
	
	private void refreshDivSplites() {
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			Object obj = children.get(i);
			if (obj instanceof DivSplitEditPart) {
				((DivSplitEditPart) obj).refreshVisuals();
			} else if (obj instanceof SplitLineEditPart) {
				((SplitLineEditPart) obj).refreshVisuals();
			}
		}		
	}
	
	public Command getCreateCommand(Object parent, Object node) {
		Component widget = (Component) node;

		if (widget.getChildren().size() <= 0) {
			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
				
			ComponentLibrary library = dynaClass.getLibrary();
			DynaComponentClass divClass = (DynaComponentClass)
				ComponentRegistry.getComponentType(
						library.getNamespaceURI(), "divSplit");
			
			DynaComponent divFirst = new DynaComponent(divClass);
			DynaComponent divSecond = new DynaComponent(divClass);
			divFirst.setName("divNew");
			divSecond.setName("divNew1");
			ComponentUtils.setUniqueName(((Component) parent).getLayout(), divFirst);
			ComponentUtils.setUniqueName(((Component) parent).getLayout(), divSecond);
			widget.addChild(divFirst);
			widget.addChild(divSecond);
		}
		return  new AddComponentCommand((Component) parent, widget);
	}

	public boolean canAddChild(Object widget) {
		return false;
	}
	
	public double getProp() {
		return ((Double) ((DynaComponent) getModel()).get("prop")).doubleValue();
	}
	
	public void setProp(double prop) {
		((DynaComponent) getModel()).set("prop", new Double(prop));
	}
	
	public String getOrientation() {
		return (String) ((DynaComponent) getModel()).get("orientation");
	}
}

