#include "head.h"
#include <string.h>
#include <stdio.h>
extern struct TASKCTL *task_control;
extern struct biosinfo *basic;
extern struct wcontrol *window_control;
extern struct tcontrol *timer_control;
extern struct mouse_dec *dec;
extern unsigned short table_8_565[256];
void boot_as_gui(struct manager *memory)
{
  into_gui(memory);
  return;
}
void boot_as_cui(struct manager *memory)
{
  task_control->task_keyboard=task_alloc();
  task_control->task_keyboard->stack=alloc4(memory,64*1024);
  task_control->task_keyboard->tss.esp=task_control->task_keyboard->stack+64*1024;
  task_control->task_keyboard->tss.eip=(int) &keyboard_task_cui;
  task_control->task_keyboard->tss.es=1*8;
  task_control->task_keyboard->tss.cs=2*8;
  task_control->task_keyboard->tss.ss=1*8;
  task_control->task_keyboard->tss.ds=1*8;
  task_control->task_keyboard->tss.fs=1*8;
  task_control->task_keyboard->tss.gs=1*8;
  fifo_init(&(task_control->task_keyboard->fifo),KEYBOARD_BUFFER_LENGTH,task_control->task_keyboard);
  task_run(task_control->task_keyboard,2,2);
  
  enable_keyboard();
  io_out_eight(pic0_imr,0xf8);	/* PITPIC1ƃL[{[h(11111000) */
  
  task_control->cui_console_task=into_cui(memory);
}
struct TASK *into_cui(struct manager *memory)
{
  struct TASK *cui_console_task;
  cui_console_task=task_alloc();
  cui_console_task->stack=alloc4(memory,64*1024);
  cui_console_task->tss.esp=cui_console_task->stack+64*1024;
  cui_console_task->tss.eip=(int) &cui_console;
  cui_console_task->tss.es=1*8;
  cui_console_task->tss.cs=2*8;
  cui_console_task->tss.ss=1*8;
  cui_console_task->tss.ds=1*8;
  cui_console_task->tss.fs=1*8;
  cui_console_task->tss.gs=1*8;
  fifo_init(&(cui_console_task->fifo),CUI_BUFFER_LENGTH,cui_console_task);
  task_run(cui_console_task,2,2);
  return cui_console_task;
}
void into_gui(struct manager *memory)
{
  int i,j;

  static char cursor[MOUSE_CURSOR_YSIZE][MOUSE_CURSOR_XSIZE]={
    "++++++++++",
    "++++------",
    "++++------",
    "++++------",
    "+---------",
    "+---------",
    "+---------",
    "+---------",
    "+---------",
    "+---------"
  };
  window_control_init();
  dec=(struct mouse_dec *)alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct mouse_dec));

  task_control->task_keyboard=task_alloc();
  task_control->task_keyboard->stack=alloc4(memory,64*1024);
  task_control->task_keyboard->tss.esp=task_control->task_keyboard->stack+64*1024;
  task_control->task_keyboard->tss.eip=(int) &keyboard_task_gui;
  task_control->task_keyboard->tss.es=1*8;
  task_control->task_keyboard->tss.cs=2*8;
  task_control->task_keyboard->tss.ss=1*8;
  task_control->task_keyboard->tss.ds=1*8;
  task_control->task_keyboard->tss.fs=1*8;
  task_control->task_keyboard->tss.gs=1*8;
  fifo_init(&(task_control->task_keyboard->fifo),KEYBOARD_BUFFER_LENGTH,task_control->task_keyboard);
  task_run(task_control->task_keyboard,2,2);
  
  enable_keyboard();
  io_out_eight(pic0_imr,0xf8);	/* PITPIC1ƃL[{[h(11111000) */
  
  task_control->task_mouse=task_alloc();
  task_control->task_mouse->stack=alloc4(memory,64*1024);
  task_control->task_mouse->tss.esp=task_control->task_mouse->stack+64*1024;
  task_control->task_mouse->tss.eip=(int) &mouse_task;
  task_control->task_mouse->tss.es=1*8;
  task_control->task_mouse->tss.cs=2*8;
  task_control->task_mouse->tss.ss=1*8;
  task_control->task_mouse->tss.ds=1*8;
  task_control->task_mouse->tss.fs=1*8;
  task_control->task_mouse->tss.gs=1*8;
  fifo_init(&(task_control->task_mouse->fifo),MOUSE_BUFFER_LENGTH,task_control->task_mouse);
  
  enable_mouse();
  io_out_eight(pic1_imr,0xef); /* }EX(11101111) */
  task_run(task_control->task_mouse,2,2);
  
  task_control->task_close=task_alloc();
  task_control->task_close->stack=alloc4(memory,64*1024);
  task_control->task_close->tss.esp=task_control->task_close->stack+64*1024;
  task_control->task_close->tss.eip=(int) &close_task;
  task_control->task_close->tss.es=1*8;
  task_control->task_close->tss.cs=2*8;
  task_control->task_close->tss.ss=1*8;
  task_control->task_close->tss.ds=1*8;
  task_control->task_close->tss.fs=1*8;
  task_control->task_close->tss.gs=1*8;
  fifo_init(&(task_control->task_close->fifo),close_buffer_length,task_control->task_close);
  task_run(task_control->task_close,2,10);
  window_control->back_window=make_external_window(0,0,basic->fullx,basic->fully,-1);
  for(j=0;j<basic->fully;j++){
    for(i=0;i<basic->fullx;i++){
      window_control->back_window->buffer[j*basic->fullx+i]=KURO;
    }
  }
  window_control->mouse_window=make_external_window(0,0,MOUSE_CURSOR_XSIZE,MOUSE_CURSOR_YSIZE,1);
  for(j=0;j<MOUSE_CURSOR_YSIZE;j++){
    for(i=0;i<MOUSE_CURSOR_XSIZE;i++){
      if(cursor[j][i]=='+'){
	window_control->mouse_window->buffer[j*MOUSE_CURSOR_XSIZE+i]=SIRO;
      }else{
	window_control->mouse_window->buffer[j*MOUSE_CURSOR_XSIZE+i]=1;
      }
    }
  }
  for(j=0;j<TASKBAR_WIDTH;j++){
    for(i=0;i<basic->fullx;i++){
      window_control->back_window->buffer[j*basic->fullx+i]=TASKBAR_COLOR;
    }
  }
  move_window(window_control->back_window,0,0);
  move_window(window_control->mouse_window,0,0);
  switch_window(window_control->back_window,0);
  switch_window(window_control->mouse_window,1);
  return;
}
#define CUICONSOLE_STR_COLOR 0xffff
#define CUICONSOLE_BACK_COLOR 0x0000
void cui_console(void)
{
  int i,j;
  char s[30];
  struct TASK *task=task_now();
  struct CUICONSOLE cons;
  cons.cur_x=0;
  cons.cur_y=0;
  cons.cmdline_count=0;
  welcome_message(&cons);
  cons.timer=make_timer();
  setfifo(cons.timer,&task->fifo);
  setdata_timer(cons.timer,0);
  timer_settime(cons.timer,50);

  print_cons_cui(&cons,">>",CUICONSOLE_STR_COLOR);
  
  for(;;){
    io_cli();
    if(fifo_status(&task->fifo)==0){
      task_sleep(task);
      io_sti();
    }else{
      i=fifo_out(&task->fifo);
      io_sti();
      if(i==0){
	dbox(
		      cons.cur_x,
		      cons.cur_y,
		      cons.cur_x+font_xsize,
		      cons.cur_y+font_ysize,
		      CUICONSOLE_BACK_COLOR);
	setdata_timer(cons.timer,1);
	timer_settime(cons.timer,50);
      }else if(i==1){
	dbox(
		      cons.cur_x,
		      cons.cur_y,
		      cons.cur_x+font_xsize,
		      cons.cur_y+font_ysize,
		      CUICONSOLE_STR_COLOR);
	setdata_timer(cons.timer,0);
	timer_settime(cons.timer,50);
      }
      if(i>=256 && i<=511){
	if(i==(8+256)){
	  if(cons.cur_x>font_xsize){
	    dbox(
			  cons.cur_x,
			  cons.cur_y,
			  cons.cur_x+font_xsize,
			  cons.cur_y+font_ysize,
			  CUICONSOLE_BACK_COLOR);
	    cons.cmdline_count--;
	    cons.cur_x-=font_xsize;
	  }
	}else if(i==(10+256)){
	  cons.cmdline[cons.cmdline_count]=0;
	  cons.cmdline_count=0;
	  cuicons_newline(&cons);
	  dbox(
			cons.cur_x,
			cons.cur_y,
			cons.cur_x+font_xsize,
			cons.cur_y+font_ysize,
			CUICONSOLE_BACK_COLOR);
	  cons_cui_runcmd(&cons);
	  print_cons_cui(&cons,">>",CUICONSOLE_STR_COLOR);
	}else{
	  if(cons.cur_x<(basic->fullx-font_xsize)){
	    s[0]=i-256;
	    s[1]=0;
	    dbox(
			  cons.cur_x,
			  cons.cur_y,
			  cons.cur_x+font_xsize,
			  cons.cur_y+font_ysize,
			  CUICONSOLE_BACK_COLOR);
	    cons.cmdline[cons.cmdline_count]=i-256;
	    cons.cmdline_count++;
	    print_cons_cui(&cons,s,CUICONSOLE_STR_COLOR);
	  }
	}
      }
    }
  }
}
void print_cons_cui(struct CUICONSOLE *cons,char *str,int color)
{
  int i;
  for(i=0;str[i]!=0x00;i++){
    print_cons_cui_char(cons,str[i],color);
  }
  return;
}
void print_cons_cui_char(struct CUICONSOLE *cons,char chr,int color)
{
  char s[2];
  s[0]=chr;
  s[1]=0;
  if(s[0]==0x09){
    for(;;){
      if((cons->cur_x&0x1f)==0){
	break;
      }
    }
  }else if(s[0]==0x0a){
    cuicons_newline(cons);
  }else if(s[0]==0x0d){
      
  }else{
    dprint(s,cons->cur_x,cons->cur_y,color);
    cons->cur_x+=font_xsize;
    if(cons->cur_x>basic->fullx){
      cuicons_newline(cons);
    }
  }
}
void cuicons_newline(struct CUICONSOLE *cons)
{
  int i,j;
  if(cons->cur_y<basic->fully){
    cons->cur_y+=font_ysize;
  }else{
    for(j=0;j<basic->fully;j++){
      for(i=0;i<basic->fullx;i++){
	basic->vram[j*basic->fullx+i]=basic->vram[(j+font_ysize)*basic->fullx+i];
      }
    }
    dbox(0,basic->fully-font_ysize,basic->fullx,basic->fully,CUICONSOLE_BACK_COLOR);
  }
  cons->cur_x=0;
  return;
}
void welcome_message(struct CUICONSOLE *cons)
{
  int i,j;
  char mes[]="BOOT PROCESS FINISHED";
  for(i=0;i<(basic->fullx/2/font_xsize-strlen(mes)/2);i++){
    print_cons_cui(cons,"-",0x8fb0);
  }
  print_cons_cui(cons,mes,0x8fb0);
  for(;i<basic->fullx/font_xsize-strlen(mes);i++){
    print_cons_cui(cons,"-",0x8fb0);
  }
  print_cons_cui(cons,"\n",0x0000);
  print_cons_cui(cons,"WELCOME TO MASK OS BY MASKY\n",0xf3bb);
  print_cons_cui(cons,"TO ENTER GUI MODE,TYPE \"gui\"\n",0x87bd);
}
void cons_cui_runcmd(struct CUICONSOLE *cons)
{
  if(strcmp(cons->cmdline,"mem")==0){
    char s[20];
    sprintf(s,"FREE %uKB",memory_total((struct manager *)(MANAGER_ADDR)));
    print_cons_cui(cons,s,CUICONSOLE_STR_COLOR);
    cuicons_newline(cons);
  }else if(strcmp(cons->cmdline,"ls")==0){
    int x,y;
    char s[30];
    struct FILEINFO *finfo=(struct FILEINFO *)(ADR_DISKIMG+0x002600);
    for(x=0;x<MAX_FILES;x++){
      if(finfo[x].name[0]==0x00){
	break;
      }
      if(finfo[x].name[0]!=0xe5){
	if((finfo[x].type&0x18)==0){
	  if((finfo[x].type&0x10)==0 && (finfo[x].type&0x08)!=0){
	    print_cons_cui(cons,"DIR ",CUICONSOLE_STR_COLOR);
	  }
	  sprintf(s,"filename.ext size:%7d",finfo[x].size);
	  for(y=0;y<8;y++){
	    s[y]=finfo[x].name[y];
	  }
	  s[9]=finfo[x].ext[0];
	  s[10]=finfo[x].ext[1];
	  s[11]=finfo[x].ext[2];
	  print_cons_cui(cons,s,CUICONSOLE_STR_COLOR);
	  cuicons_newline(cons);
	}
      }
    }
  }else if(strcmp(cons->cmdline,"gui")==0){
    struct TASK *task=task_now();
    dbox(0,0,basic->fullx,basic->fully,0x0000);
    timer_cancel(cons->timer);
    task_sleep(task_control->task_keyboard);
    task_control->task_keyboard->tss.eip=(int) &keyboard_task_gui;
    task_run(task_control->task_keyboard,2,2);
    into_gui((struct manager *)(MANAGER_ADDR));
    free4((struct manager *)(MANAGER_ADDR),task->stack,64*1024);
    free4((struct manager *)(MANAGER_ADDR),(int)task->fifo.buffer,CUI_BUFFER_LENGTH*4);
    io_cli();
    task->flag=TASK_NOT_USING;
    io_sti();
    task_sleep(task);
  }
}
