#include "head.h"
#include <stdio.h>
#include <string.h>
extern struct TASKCTL *task_control;
struct fifo que_fdc_int;
int result[7];
extern struct FDC_REQ *freq_fat0, *freq_fat1;
void func_fdc(void);
void wait(int time);
void wait_data(struct fifo *que, int data);
int fdc_seek_0(void);
int fdc_seek(char cyl, char head);
int fdc_send_write_cmd(char cyl, char head, char sector);
int fdc_send_read_cmd(char cyl, char head, char sector);
int fdc_get_result();
void fdc_test(void);
void dbg_put(char *s);
void fdc_ready_sendcmd(int cmd);
void fdc_sendcmd(int cmd);

extern char *already_read;

void task_floppy(void)		/* func_fdc */
{
  int cmd, moter = MOTER_ON, secno, num, cyl, head, sector, i, err = SUCCESS;
  struct timer *tmr = make_timer();
  setfifo(tmr,&task_control->task_fdc->fifo);
  setdata_timer(tmr,0xff<<24);
  // ŏ1xĂׂݒ 
  io_out_eight(0x00d6, 0xc0); // }X^ch0JXP[h[h
  io_out_eight(0x00c0, 0x00); // X[uDMA
  io_out_eight(0x000a, 0x06); // }X^ch2DMA}XN
	
  // DMA = 0x00400000 ` 0x00402400
	
  for (;;) {
    io_cli();
    if (fifo_status(&task_control->task_fdc->fifo) == 0) {
      if (moter == MOTER_ON) {
	// Ob烂[^[Itɂ
	timer_settime(tmr, 300);
      }
      flush_fdc_req(freq_fat0);
      flush_fdc_req(freq_fat1);
      task_sleep(task_control->task_fdc);
      io_sti();
			
    } else {
      i = fifo_out(&task_control->task_fdc->fifo);
      io_sti();
      secno = i & 0xffff;
      num = (i >> 16) & 0xff;
      cmd = (i >> 24) & 0xff;
			
      if (cmd == CMD_MOTER_OFF) {
	io_out_eight(0x03f2, 0x0c);
	moter = MOTER_OFF;
				
      } else {
	timer_cancel(tmr);
				
	cyl = secno / 36; secno %= 36;
	head = secno / 18; secno %= 18;
	sector = secno + 1;
	// [^[on & V[N
	if (moter == MOTER_OFF) {
	  moter = MOTER_ON;
	  io_out_eight(0x03f2, 0x1c); 
	  wait(300);
	}
	fdc_seek(cyl, head);
				
	if (cmd == 'r') { // Read
	  // [hݒFf}hEAhXEւ̏݁Ech2
	  io_out_eight(0x000b, 0x06);
	  // oCg̐ݒ
	  io_out_eight(0x0005, 0xff); 
	  io_out_eight(0x0005, num * 2 - 1);
	  // Ԓn̐ݒ
	  io_out_eight(0x0004, ADR_FDC_DMA & 0xff); 
	  io_out_eight(0x0004, (ADR_FDC_DMA >> 8) & 0xff); 
	  io_out_eight(0x0081, (ADR_FDC_DMA >> 16) & 0xff); 
	  // }X^ch2DMA}XN
	  io_out_eight(0x000a, 0x02);
					
	  err = fdc_send_read_cmd(cyl, head, sector);
	  memcpy((char *) (ADR_DISKIMG + (cyl * 36 + head * 18 + sector - 1) * 512), (char *) ADR_FDC_DMA, 512 * num);
	  for (i = 0; i < num; i++) {
	    already_read[cyl * 36 + head * 18 + (sector + i - 1)] = 0xff;
	  }
					
	} else if (cmd == 'w') { // Write
	  // [hݒFf}hEAhXE̓ǂݍ݁Ech2
	  io_out_eight(0x000b, 0x0a); 
	  // oCg̐ݒ
	  io_out_eight(0x0005, 0xff); 
	  io_out_eight(0x0005, num * 2 - 1);
	  // Ԓn̐ݒ
	  io_out_eight(0x0004, ADR_FDC_DMA & 0xff); 
	  io_out_eight(0x0004, (ADR_FDC_DMA >> 8) & 0xff); 
	  io_out_eight(0x0081, (ADR_FDC_DMA >> 16) & 0xff); 
	  // }X^ch2DMA}XN
	  io_out_eight(0x000a, 0x02);
					
	  memcpy((char *) ADR_FDC_DMA, (char *) (ADR_DISKIMG + (cyl * 36 + head * 18 + sector - 1) * 512), 512 * num);
	  err = fdc_send_write_cmd(cyl, head, sector);
	  for (i = 0; i < num; i++) {
	    already_read[cyl * 36 + head * 18 + (sector + num - 1) ] = 0xff;
	  }
	}
				
	// }X^ch2DMA}XN
	io_out_eight(0x000a, 0x06); 
      }
    }
  }
}

int fdc_sense_int_status(void)
{
  fdc_ready_sendcmd(0x08);
  fdc_sendcmd(0x08);
	
  while ((io_in_eight(0x03f4) & 0xc0) != 0xc0);
  result[ST0] = io_in_eight(0x03f5);
  while ((io_in_eight(0x03f4) & 0xc0) != 0xc0);
  result[CYL] = io_in_eight(0x03f5);
	
  if ((result[ST0] & 0xc0) == 0x40 || (result[ST0] & 0xc0) == 0x80) {
    // R}ḧُIAR}ĥ̂ԈĂƂُI
    return ERROR;
  } else {
    return SUCCESS;
  }
}

void fdc_ready_sendcmd(int cmd)
{
  // R}h0x08(SENSE INT STATUS)͗O
  while ((io_in_eight(0x03f4) & ((cmd != 0x08) ? 0x11 : 0x10)) != 0);
	
  return;
}

void fdc_sendcmd(int cmd)
{
  while ((io_in_eight(0x03f4) & 0xc0) != 0x80);
  io_out_eight(0x03f5, cmd);
	
  return;
}

int fdc_seek_0(void)
{
  fdc_ready_sendcmd(0x0f);
  fdc_sendcmd(0x07);
  fdc_sendcmd(0);
	
  wait_data(&que_fdc_int, 3);
  return fdc_sense_int_status();
}

int fdc_seek(char cyl, char head)
{
  fdc_ready_sendcmd(0x0f);
  fdc_sendcmd(0x0f);
  fdc_sendcmd(head << 2);
  fdc_sendcmd(cyl);
	
  wait_data(&que_fdc_int, 3);
  return fdc_sense_int_status();
}

int fdc_send_write_cmd(char cyl, char head, char sector)
{
  int cmd_list[] = {0xc5, head << 2, cyl, head, sector, 0x02, 0x7f, 0x12, 0xff}, i, cmd_err, seek_err;
	
  for (seek_err = 0; seek_err < 5; seek_err++) {
    for (cmd_err = 0; cmd_err < 5; cmd_err++) {
      fdc_ready_sendcmd(0xc5);
      for (i = 0; i < 9; i++) fdc_sendcmd(cmd_list[i]);
      // FDCINT҂
      wait_data(&que_fdc_int, 3); 
      // FDC烊UgXe[^Xǂݎ
      if (fdc_get_result() == SUCCESS) return SUCCESS;
    }
    fdc_seek_0();
  }
	
  return ERROR;
}

int fdc_send_read_cmd(char cyl, char head, char sector)
{
  int cmd_list[] = {0xe6, head << 2, cyl, head, sector, 0x02, 0x12, 0x01, 0xff}, i, cmd_err, seek_err;
	
  for (seek_err = 0; seek_err < 5; seek_err++) {
    for (cmd_err = 0; cmd_err < 5; cmd_err++) {
      fdc_ready_sendcmd(0xe6);
      for (i = 0; i < 9; i++) fdc_sendcmd(cmd_list[i]);
      // FDCINT҂
      wait_data(&que_fdc_int, 3);
      // FDC烊UgXe[^Xǂݎ
      if (fdc_get_result() == SUCCESS) return SUCCESS;
    }
    fdc_seek_0();
  }
	
  return ERROR;
}

int fdc_get_result()
{
  int i;
	
  for (i = 0; i < 7; i++) {
    while ((io_in_eight(0x03f4) & 0xc0) != 0xc0);
    result[i] = io_in_eight(0x03f5);
  }
	
  if ((result[ST0] & 0xc0) == 0x40 || (result[ST0] & 0xc0) == 0x80 ) {
    // R}ḧُIAR}ĥ̂ԈĂƂُI
    return ERROR;
  } else {
    return SUCCESS;
  }
}

void wait(int time)
{
  struct TASK *task = task_now();
  struct timer *tmr = make_timer();
  struct fifo que;
  int buf[10];
	
  fifo_init_console(&que,10,buf,task);
  setfifo(tmr,&que);
  setdata_timer(tmr,1);
  timer_settime(tmr, time);
  wait_data(&que, 1);
	
  timer_cancel(tmr);
	
  return;
}

void wait_data(struct fifo *que, int data)
{
  int i;
  struct TASK *task = task_now();
	
  for (;;) {
    io_cli();
    if (fifo_status(que) == 0) {
      task_sleep(task);
      io_sti();
    } else {
      io_sti();
      i = fifo_out(que);
      i &= 0x0fffffff;
      if (i == data) {
	return;
      }
    }
  }
}

int wait_something(struct fifo *que)
{
  struct TASK *task = task_now();
	
  for (;;) {
    io_cli();
    if (fifo_status(que) == 0) {
      task_sleep(task);
      io_sti();
    } else {
      return fifo_out(que);
    }
  }
}


struct FDC_REQ *start_fdc_req(int mode)
{
  struct FDC_REQ *freq = (struct FDC_REQ *) alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct FDC_REQ));
  freq->mode = mode;
  freq->cyl = 0;
  freq->head = 0;
  freq->num = 0;
  freq->sector_bgn = 0;
  freq->sector_end = 0;
	
  return freq;
}

void add_fdc_req(struct FDC_REQ *freq, int secno)
{
  int cyl, head, sector, _secno = secno;
  cyl = secno / 36; secno %= 36;
  head = secno / 18; secno %= 18;
  sector = secno + 1;
	
  if (freq->mode == 'w') {
    already_read[_secno] = 0xff;
  } else if (freq->mode == 'r' && already_read[_secno] != 0) {
    return;
  }
	
  if (freq->num == 0) {
    // ߂
    freq->cyl = cyl;
    freq->head = head;
    freq->sector_bgn = sector;
    freq->sector_end = sector;
    freq->num = 1;
		
  } else if ((freq->cyl != cyl && freq->head != head) || (freq->sector_end + 1 != sector && freq->sector_end != sector)) {
    // AȂǉ
    io_cli();
    fifo_in(&task_control->task_fdc->fifo, (freq->mode << 24) | (freq->num << 16) | (freq->cyl * 36 + freq->head * 18 + (freq->sector_bgn - 1)));
    io_sti();
    freq->cyl = cyl;
    freq->head = head;
    freq->sector_bgn = sector;
    freq->sector_end = sector;
    freq->num = 1;
		
  } else if (freq->sector_end != sector) {
    // Aǉ
    freq->sector_end++;
    freq->num++;
  }
}

void add_fdc_req_addr(struct FDC_REQ *freq, char *addr, int size)
{
  int i;
  int clustno_bgn = ((int) addr) / 512;
  int clustno_end = ((int) addr + size) / 512;
	
  for (i = clustno_bgn; i <= clustno_end; i++) {
    add_fdc_req(freq, i);
  }
}

void flush_fdc_req(struct FDC_REQ *freq)
{
  if (freq->num != 0) {
    io_cli();
    fifo_in(&task_control->task_fdc->fifo, (freq->mode << 24) | (freq->num << 16) | (freq->cyl * 36 + freq->head * 18 + (freq->sector_bgn - 1)));
    io_sti();
    freq->num = 0;
  }
}

void end_fdc_req(struct FDC_REQ *freq)
{
  flush_fdc_req(freq);
  free4((struct manager *)(MANAGER_ADDR), (int) freq, sizeof (struct FDC_REQ));
}
