#include "head.h"
extern struct biosinfo *basic;
extern struct wcontrol *window_control;

void box(struct window *handle,int x_start,int y_start,int x_end,int y_end,int color)
{
  int x,y;
  unsigned short *buffer=(unsigned short *)handle->buffer;
  for(y=y_start;y<=y_end;y++){
    for(x=x_start;x<=x_end;x++){
      buffer[y*handle->xsize+x]=color;
    }
  }
  refresh_window(handle,x_start,y_start,x_end,y_end);
  return;
}
void dbox(int x_start,int y_start,int x_end,int y_end,int color)
{
  int x,y;
  unsigned short *vram=(unsigned short *)basic->vram;
  for(y=y_start;y<=y_end;y++) {
    for(x=x_start;x<=x_end;x++)
      vram[y*basic->fullx+x]=color;
  }
  return;
}
void dot(struct window *handle,int x,int y,int color)
{
  handle->buffer[y*handle->xsize+x]=color;
  refresh_window(handle,x,y,x+1,y+1);
  return;
}
void print(struct window *handle,char *str,int x,int y,int color)
{
  extern char alpha[4096];
  int i;
  for(i=0;str[i]!=0x00;i++){
    print_font((short *)handle->buffer,handle->xsize,x+i*font_xsize,y,color,alpha+str[i]*font_ysize);
  }
  refresh_window(handle,x,y,x+i*font_xsize,y+i*font_ysize);
  return;
}

void dprint(char *str,int x,int y,int color)
{
  extern char alpha[4096];
  int i;
  for(i=0;str[i]!=0x00;i++){
    print_font((short *)basic->vram,basic->fullx,x+i*font_xsize,y,color,alpha+str[i]*font_ysize);
  }
  return;
}
void print_font(short *buffer,int xsize,int x,int y,int color,char *font)
{
  short *write_position;
  char data;
  int i;
  for(i=0;i<font_ysize;i++){
    write_position=buffer+(y+i)*xsize+x;
    data=font[i];
    if((data&0x80)!=0){write_position[0]=color;}
    if((data&0x40)!=0){write_position[1]=color;}
    if((data&0x20)!=0){write_position[2]=color;}
    if((data&0x10)!=0){write_position[3]=color;}
    if((data&0x08)!=0){write_position[4]=color;}
    if((data&0x04)!=0){write_position[5]=color;}
    if((data&0x02)!=0){write_position[6]=color;}
    if((data&0x01)!=0){write_position[7]=color;}
  }
}
void print_refreshly(struct window *handle,char *str,int x,int y,int length,int haikei,int mozi)
{
  box(handle,x,y,x+length*font_xsize,y+font_ysize,haikei);
  print(handle,str,x,y,mozi);
}
void line(struct window *window,int x0,int y0,int x1,int y1,int col)
{
  int i, x, y, len, dx, dy;
  unsigned short *sp;

  dx = x1 - x0;
  dy = y1 - y0;
  x = x0 << 10;
  y = y0 << 10;
  if (dx < 0){
    dx = - dx;
  }
  if (dy < 0){
    dy = - dy;
  }
  if (dx >= dy) {
    len = dx + 1;
    if (x0 > x1) {
      dx = - 1024;
    } else {
      dx = 1024;
    }
    if (y0 <= y1) {
      dy = ((y1 - y0 + 1) << 10) / len;
    } else {
      dy = ((y1 - y0 - 1) << 10) / len;
    }
  } else {
    len = dy + 1;
    if (y0 > y1) {
      dy = - 1024;
    } else {
      dy = 1024;
    }
    if (x0 <= x1) {
      dx = ((x1 - x0 + 1) << 10) / len;
    } else {
      dx = ((x1 - x0 - 1) << 10) / len;
    }
  }

  sp = (unsigned short *) (window->buffer);
  for (i = 0; i < len; i++) {
    sp[(y >> 10) * window->xsize + (x >> 10)] =col;
    x += dx;
    y += dy;
  }
  return;
}
