#include "head.h"
#include <stdio.h>
struct TASKCTL *task_control;
struct biosinfo *basic;
struct mouse_dec *dec;
struct tcontrol *timer_control;
struct wcontrol *window_control;
struct manager *memory;
struct ICONCTL *icon_ctl;
int *fat;
void HariMain(void)
{
  struct TASK *task_a;
  unsigned int memtotal;
  struct PICTURE *pict;
  char s[10];

  gdt_idt_init();
  init_pic();
  io_sti();
  enable_pit();
  memtotal=memtest(0x00400000,0xbfffffff);
  memory=(struct manager *)MANAGER_ADDR;
  manager_init(memory);
  free((struct manager *)(MANAGER_ADDR),0x00001000,0x0009e000);
  free((struct manager *)(MANAGER_ADDR),0x00400000+0x12*512,memtotal-0x00400000);
  basic=(struct biosinfo *)BIOS_INFO_ADDR;
  timer_control_init();

  /* J[l^XN */
  task_a=task_init();
  task_run(task_a,2,2);
  boot_as_gui(memory);  
  task_control->task_fdc=task_alloc();
  task_control->task_fdc->stack=alloc4(memory,64*1024);
  task_control->task_fdc->tss.esp=task_control->task_fdc->stack+64*1024;
  task_control->task_fdc->tss.eip=(int) &task_floppy;
  task_control->task_fdc->tss.es=1*8;
  task_control->task_fdc->tss.cs=2*8;
  task_control->task_fdc->tss.ss=1*8;
  task_control->task_fdc->tss.ds=1*8;
  task_control->task_fdc->tss.fs=1*8;
  task_control->task_fdc->tss.gs=1*8;
  fifo_init(&(task_control->task_fdc->fifo),FDC_BUFFER_LENGTH,task_control->task_fdc);
  task_run(task_control->task_fdc,2,2);

  file_readfat(fat,(unsigned char *)(ADR_DISKIMG+0x000200));

  /* ICONS */
  /* pict=loadicon("HAYABUSA.BMP"); */
  /* drawicon(pict,window_control->back_window,0,0); */
  /* i=loadicon("COMPUTER.BMP"); */
  /* drawicon(icon_ctl->icon[i],window_control->back_window,0,0); */
  /* i=loadicon("FLOPPY.BMP"); */
  /* drawicon(icon_ctl->icon[i],window_control->back_window,0,32); */
  /* i=loadicon("HARDDISK.BMP"); */
  /* drawicon(icon_ctl->icon[i],window_control->back_window,0,64); */
  /* i=loadicon("TERMINAL.BMP"); */
  /* drawicon(icon_ctl->icon[i],window_control->back_window,0,96); */
  /* i=loadicon("WINDOWS.BMP"); */
  /* drawicon(icon_ctl->icon[i],window_control->back_window,0,128); */
  /* y[WO̊Jn */
  /* initVirtualMemoryManagement(); /\* hLhL *\/ */
  task_sleep(task_a);
  for(;;){
  }
}
void keyboard_task_cui(void)
{
  unsigned char s[100];
  int harddata;
  static char keytable0[0x80] = {
    0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
    'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
    'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
    'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
    '2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
  };
  static char keytable1[0x80] = {
    0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
    'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
    'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
    'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
    '2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
  };
  int key_shift=0,key_leds=(basic->leds>>4)&7,key_alt=0,key_ctrl=0,keycmd_wait=-1,j;
  struct fifo keycmd;
  fifo_init(&keycmd,32,0);
  fifo_in(&keycmd,KEYCMD_LED);
  fifo_in(&keycmd,key_leds);
  for(;;){
    if(fifo_status(&keycmd)>0 && keycmd_wait<0){
      keycmd_wait=fifo_out(&keycmd);
      wait_kbc_sendready();
      io_out_eight(port_keydat,keycmd_wait);
    }
    io_cli();
    if(fifo_status(&(task_control->task_keyboard->fifo))==0){
      task_sleep(task_control->task_keyboard);
      io_sti();
    }else{
      harddata=fifo_out(&(task_control->task_keyboard->fifo));
      io_sti();
      if(harddata<0x80){
	if(key_shift==0){
	  s[0]=keytable0[harddata];
	}else{
	  s[0]=keytable1[harddata];
	}
	if('A'<=s[0]&&s[0]<='Z'){
	  if(((key_leds&4)==0 && key_shift==0)||((key_leds&4)!=0 && key_shift!=0)){
	    s[0]+=0x20;
	  }
	}
	if(s[0]!=0){
	  fifo_in(&task_control->cui_console_task->fifo,s[0]+256);
	  /* f[^͗ĂBfifoɐɎ󂯎Ȃ */
	}
      }
      if(harddata==0x2a){	/* Vtg on */
	key_shift|=1;
      }else if(harddata==0x36){	/* EVtg on*/
	key_shift|=2;
      }else if(harddata==0xaa){	/* Vtg off */
	key_shift&=~1;
      }else if(harddata==0xb6){	/* EVtg off */
	key_shift&=~2;
      }else if(harddata==0x38){	/* AltL[ on */
	key_alt|=1;
	fifo_in(&task_control->cui_console_task->fifo,0x38);
      }else if(harddata==0x38+0x80){ /* AltL[ off */
	key_alt&=~1;
	fifo_in(&task_control->cui_console_task->fifo,0x38+0x80);
      }else if(harddata==0x1d){	/* CtrlL[ on */
	key_ctrl|=1;
	fifo_in(&task_control->cui_console_task->fifo,0x1d);
      }else if(harddata==0x1d+0x80){ /* CtrlL[ off */
	key_ctrl&=~1;
	fifo_in(&task_control->cui_console_task->fifo,0x1d+0x80);
      }else if(harddata==0x48){	/* UP */
	fifo_in(&task_control->cui_console_task->fifo,0x48);
      }else if(harddata==0x4b){	/* LEFT */
	fifo_in(&task_control->cui_console_task->fifo,0x4b);
      }else if(harddata==0x4d){	/* RIGHT */
	fifo_in(&task_control->cui_console_task->fifo,0x4d);
      }else if(harddata==0x50){	/* DOWN */
	fifo_in(&task_control->cui_console_task->fifo,0x50);
      }else if(harddata==0x3a){	/* capslock */
	key_leds^=4;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0x45){	/* numlock */
	key_leds^=2;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0x46){	/* scroll lock */
	key_leds^=1;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0xfa){	/* L[{[hf[^𖳎Ɏ󂯎 */
	keycmd_wait=-1;
      }else if(harddata==0xfe){	/* L[{[hf[^󂯎Ȃ */
	wait_kbc_sendready();
	io_out_eight(port_keydat,keycmd_wait);
      }
    }
  }
}

void keyboard_task_gui(void)
{
  unsigned char s[100];
  int harddata;
  static char keytable0[0x80] = {
    0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
    'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
    'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
    'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
    '2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
  };
  static char keytable1[0x80] = {
    0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
    'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
    'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
    'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
    '2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
  };
  int key_shift=0,key_leds=(basic->leds>>4)&7,key_alt=0,key_ctrl=0,keycmd_wait=-1,j;
  struct fifo keycmd;
  
  struct window *virtual;

  fifo_init(&keycmd,32,0);
  fifo_in(&keycmd,KEYCMD_LED);
  fifo_in(&keycmd,key_leds);
  for(;;){
    if(fifo_status(&keycmd)>0 && keycmd_wait<0){
      keycmd_wait=fifo_out(&keycmd);
      wait_kbc_sendready();
      io_out_eight(port_keydat,keycmd_wait);
    }
    io_cli();
    if(fifo_status(&(task_control->task_keyboard->fifo))==0){
      task_sleep(task_control->task_keyboard);
      io_sti();
    }else{
      harddata=fifo_out(&(task_control->task_keyboard->fifo));
      io_sti();
      if(harddata<0x80){
	if(key_shift==0){
	  s[0]=keytable0[harddata];
	}else{
	  s[0]=keytable1[harddata];
	}
	if('A'<=s[0]&&s[0]<='Z'){
	  if(((key_leds&4)==0 && key_shift==0)||((key_leds&4)!=0 && key_shift!=0)){
	    s[0]+=0x20;
	  }
	}
	if(window_control->key_win!=0){
	  if(s[0]!=0){
	    fifo_in(&window_control->key_win->task->fifo,s[0]+256);
	  }
	}
      }
      if(harddata==0x01 && window_control->key_win!=0 && window_control->key_win->task->tss.ss0!=0){	/* ESCL[ */
	print_cons(window_control->key_win->task->cons,"\ninterupt\n",SIRO);
	io_cli();
	window_control->key_win->task->tss.eax=(int)&(window_control->key_win->task->tss.esp0);
	window_control->key_win->task->tss.eip=(int)asm_end_app;
	io_sti();
	task_run(window_control->key_win->task,-1,0);
      }else if(harddata==0x0f && window_control->key_win!=0){ /* tab */
	keywin_off(window_control->key_win);
	j=window_control->key_win->height-1;
	if(j==1){
	  j=window_control->top-1;
	}
	window_control->key_win=window_control->window_pointer[j];
	keywin_on(window_control->key_win);
      }else if(harddata==0x3b && window_control->top>4 && window_control->key_win!=0){	/* F1 */
	switch_window(window_control->window_pointer[3],window_control->top-1);
      }else if(harddata==0x3c){	/* F2 */
	if(window_control->key_win!=0){
	  keywin_off(window_control->key_win);
	}
	window_control->key_win=open_console();
	switch_window_top(window_control->key_win);
	keywin_on(window_control->key_win);
      }else if(harddata==0x3d){	/* F3 */
	if(window_control->key_win!=0){
	  keywin_off(window_control->key_win);
	}
	window_control->key_win=open_OREconsole();
	switch_window_top(window_control->key_win);
	keywin_on(window_control->key_win);
      }else if(harddata==0x3e){	/* F4 */
	if(window_control->key_win!=0){
	  keywin_off(window_control->key_win);
	}
	window_control->key_win=open_pad();
	switch_window_top(window_control->key_win);
	keywin_on(window_control->key_win);
      }else if(harddata==0x3f){	/* EBhEZNgj[ */
	if(window_control->key_win!=0){
	  keywin_off(window_control->key_win);
	}
	window_control->key_win=open_selectmenu();
	switch_window_top(window_control->key_win);
	keywin_on(window_control->key_win);
      }else if(harddata==0x2a){	/* Vtg on */
	key_shift|=1;
      }else if(harddata==0x36){	/* EVtg on*/
	key_shift|=2;
      }else if(harddata==0xaa){	/* Vtg off */
	key_shift&=~1;
      }else if(harddata==0xb6){	/* EVtg off */
	key_shift&=~2;
      }else if(harddata==0x38){	/* AltL[ on */
	key_alt|=1;
	fifo_in(&window_control->key_win->task->fifo,0x38);
      }else if(harddata==0x38+0x80){ /* AltL[ off */
	key_alt&=~1;
	fifo_in(&window_control->key_win->task->fifo,0x38+0x80);
      }else if(harddata==0x1d){	/* CtrlL[ on */
	key_ctrl|=1;
	fifo_in(&window_control->key_win->task->fifo,0x1d);
      }else if(harddata==0x1d+0x80){ /* CtrlL[ off */
	key_ctrl&=~1;
	fifo_in(&window_control->key_win->task->fifo,0x1d+0x80);
      }else if(harddata==0x48){	/* UP */
	fifo_in(&window_control->key_win->task->fifo,0x48);
      }else if(harddata==0x4b){	/* LEFT */
	fifo_in(&window_control->key_win->task->fifo,0x4b);
      }else if(harddata==0x4d){	/* RIGHT */
	fifo_in(&window_control->key_win->task->fifo,0x4d);
      }else if(harddata==0x50){	/* DOWN */
	fifo_in(&window_control->key_win->task->fifo,0x50);
      }else if(harddata==0x3a){	/* capslock */
	key_leds^=4;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0x45){	/* numlock */
	key_leds^=2;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0x46){	/* scroll lock */
	key_leds^=1;
	fifo_in(&keycmd,KEYCMD_LED);
	fifo_in(&keycmd,key_leds);
      }else if(harddata==0xfa){	/* L[{[hf[^𖳎Ɏ󂯎 */
	keycmd_wait=-1;
      }else if(harddata==0xfe){	/* L[{[hf[^󂯎Ȃ */
	wait_kbc_sendready();
	io_out_eight(port_keydat,keycmd_wait);
      }
    }
  }
}

void mouse_task(void)
{
  int mx=0,my=0;
  int harddata;
  int x,y,j=0;
  int mmx=-1,mmy=-1,mmx2=0,new_mx=-1,new_my=0,new_wx=0x7fffffff,new_wy=0;
  struct window *sht;
  for(;;){
    io_cli();
    if(fifo_status(&(task_control->task_mouse->fifo))==0){
      if(new_mx>=0){
	io_sti();
	move_window(window_control->mouse_window,new_mx,new_my);
	new_mx=-1;
      }else if(new_wx!=0x7fffffff){
	io_sti();
	move_window(sht,new_wx,new_wy);
	new_wx=0x7fffffff;
      }else{
	task_sleep(task_control->task_mouse);
	io_sti();
      }
    }else{
      harddata=fifo_out(&(task_control->task_mouse->fifo));
      io_sti();
      if(mouse_decode(dec,harddata)!=0){
	mx+=dec->x;my+=dec->y;
	if(mx<0)mx=0;if(my<0)my=0;if(mx>basic->fullx)mx=basic->fullx;if(my>basic->fully)my=basic->fully;
	new_mx=mx;
	new_my=my;
	if(dec->left_button!=0){
	  if(mmx<0){
	    for(j=window_control->top-1;j>0;j--){
	      sht=window_control->window_pointer[j];
	      x=mx-sht->x;
	      y=my-sht->y;
	      if(0<=x &&
		 x<sht->xsize &&
		 0<=y &&
		 y<sht->ysize){
		if(sht->buffer[y*sht->xsize+x]
		   !=sht->inv){
		  switch_window_top(sht);
		  if(sht!=window_control->key_win){
		    keywin_off(window_control->key_win);
		    window_control->key_win=sht;
		    keywin_on(window_control->key_win);
		  }
		  if(0<=x && x<sht->xsize-30 && 0<=y && y<=16){
		    mmx=mx;
		    mmy=my;
		    mmx2=sht->x;
		    new_wy=sht->y;
		  }
		  if((sht->xsize-30)<=x &&
		     x<=(sht->xsize) &&
		     0<=y &&
		     y<=16){ /* EBhE */
		    if((sht->use &0x10)!=0){
		      io_cli();
		      sht->task->tss.eax=(int)&(sht->task->tss.esp0);
		      sht->task->tss.eip=(int)asm_end_app;
		      io_sti();
		      task_run(sht->task,-1,0);
		    }else{
		      fifo_in(&(sht->task->fifo),4);
		    }
		  }
		}
		break;
	      }
	    }	      
	  }else{
	    x=mx-mmx;
	    y=my-mmy;
	    new_wx=(mmx2+x+2)&~3;
	    new_wy=new_wy+y;
	    mmy=my;
	  }
	}else{
	  mmx=-1;
	  if(new_wx!=0x7fffffff){
	    move_window(sht,new_wx,new_wy);
	    new_wx=0x7fffffff;
	  }
	}
      }else if(harddata==0x4001){
	mx=window_control->mouse_window->x;
	my=window_control->mouse_window->y;
      }
    }
  }
}
void close_task(void)
{
  int i,j;
  for(;;){
    io_cli();
    if(fifo_status(&(task_control->task_close->fifo))==0){
      task_sleep(task_control->task_close);
      io_sti();
    }else{
      i=fifo_out(&(task_control->task_close->fifo));
      io_sti();
      if(i>=256 && i<=512){
	close_console(window_control->window+(i-256));
	keywin_off(window_control->key_win);
	if(window_control->key_win!=0&&window_control->key_win->use==WINDOW_NOT_USING){
	  if(window_control->top==1){
	    window_control->key_win=0;
	  }else{
	    window_control->key_win=window_control->window_pointer[window_control->top-1];
	    keywin_on(window_control->key_win);
	  }
	}
      }else if(i>=512 && i<=768){
	close_OREconsole(window_control->window+(i-512));
	keywin_off(window_control->key_win);
	if(window_control->key_win!=0&&window_control->key_win->use==WINDOW_NOT_USING){
	  if(window_control->top==1){
	    window_control->key_win=0;
	  }else{
	    window_control->key_win=window_control->window_pointer[window_control->top-1];
	    keywin_on(window_control->key_win);
	  }
	}
      }
    }
  }
}
