/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Mailer;

class MimeMailer
extends Mailer {
    MimeMailer() {
    }

    public void send() {
        try {
            Properties props = new Properties();
            ((Hashtable)props).put("mail.smtp.host", this.host);
            ((Hashtable)props).put("mail.smtp.port", String.valueOf(this.port));
            Session sesh = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(sesh);
            MimeMultipart attachments = new MimeMultipart();
            if (this.from.getName() == null) {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress()));
            } else {
                msg.setFrom((Address)new InternetAddress(this.from.getAddress(), this.from.getName()));
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])MimeMailer.internetAddresses(this.toList));
            msg.setRecipients(Message.RecipientType.CC, (Address[])MimeMailer.internetAddresses(this.ccList));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])MimeMailer.internetAddresses(this.bccList));
            if (this.subject != null) {
                msg.setSubject(this.subject);
            }
            msg.addHeader("Date", this.getDate());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            this.message.print(out);
            out.close();
            MimeBodyPart textbody = new MimeBodyPart();
            textbody.setContent((Object)baos.toString(), this.message.getMimeType());
            attachments.addBodyPart((BodyPart)textbody);
            Enumeration e = this.files.elements();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                MimeBodyPart body = new MimeBodyPart();
                if (!file.exists() || !file.canRead()) {
                    throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not " + "readable.");
                }
                FileDataSource fileData = new FileDataSource(file);
                DataHandler fileDataHandler = new DataHandler((DataSource)fileData);
                body.setDataHandler(fileDataHandler);
                body.setFileName(file.getName());
                attachments.addBodyPart((BodyPart)body);
            }
            msg.setContent((Multipart)attachments);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new BuildException("Problem while sending mime mail:", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Problem while sending mime mail:", (Throwable)e);
        }
    }

    private static InternetAddress[] internetAddresses(Vector list) throws AddressException, UnsupportedEncodingException {
        InternetAddress[] addrs = new InternetAddress[list.size()];
        int i = 0;
        while (i < list.size()) {
            EmailAddress addr = (EmailAddress)list.elementAt(i);
            addrs[i] = addr.getName() == null ? new InternetAddress(addr.getAddress()) : new InternetAddress(addr.getAddress(), addr.getName());
            ++i;
        }
        return addrs;
    }
}

