/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.maven.changelog.ChangeLogFile;

public class ChangeLogEntry {
    public static final String LESS_THAN_ENTITY = "&lt;";
    public static final String GREATER_THAN_ENTITY = "&gt;";
    public static final String AMPERSAND_ENTITY = "&amp;";
    public static final String APOSTROPHE_ENTITY = "&apos;";
    public static final String QUOTE_ENTITY = "&quot;";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat CVS_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private Date date;
    private String author;
    private String comment = "";
    private Vector files = new Vector();

    public ChangeLogEntry(String date, String author, String comment) {
        this.setDate(date);
        this.setAuthor(author);
        this.setComment(comment);
    }

    public ChangeLogEntry() {
    }

    public void addFile(ChangeLogFile file) {
        this.files.addElement(file);
    }

    public void addFile(String file, String revision) {
        this.files.addElement(new ChangeLogFile(file, revision));
    }

    public String toString() {
        return this.author + "\n" + this.date + "\n" + this.files + "\n" + this.comment;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<changelog-entry>\n").append("\t\t<date>").append(this.getDateFormatted()).append("</date>\n").append("\t\t<time>").append(this.getTimeFormatted()).append("</time>\n").append("\t\t<author><![CDATA[").append(this.author).append("]]></author>\n");
        Enumeration e = this.files.elements();
        while (e.hasMoreElements()) {
            ChangeLogFile file = (ChangeLogFile)e.nextElement();
            buffer.append("\t\t<file>\n").append("\t\t\t<name>").append(ChangeLogEntry.escapeValue(file.getName())).append("</name>\n").append("\t\t\t<revision>").append(file.getRevision()).append("</revision>\n");
            buffer.append("\t\t</file>\n");
        }
        buffer.append("\t\t<msg><![CDATA[").append(this.comment).append("]]></msg>\n");
        buffer.append("\t</changelog-entry>\n");
        return buffer.toString();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public void setDate(String date) {
        try {
            this.date = CVS_TIMESTAMP_FORMAT.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("I don't understand this date: " + date);
        }
    }

    public String getDateFormatted() {
        return DATE_FORMAT.format(this.getDate());
    }

    public String getTimeFormatted() {
        return TIME_FORMAT.format(this.getDate());
    }

    public static final String escapeValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int i = 0;
        int size = buffer.length();
        while (i < size) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    break;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                    break;
                }
                case '\'': {
                    buffer.replace(i, i + 1, APOSTROPHE_ENTITY);
                    size += 4;
                    i += 4;
                    break;
                }
                case '\"': {
                    buffer.replace(i, i + 1, QUOTE_ENTITY);
                    size += 5;
                    i += 5;
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

