/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CvsConnection {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$cvslib$CvsConnection == null ? (class$org$apache$maven$cvslib$CvsConnection = CvsConnection.class$("org.apache.maven.cvslib.CvsConnection")) : class$org$apache$maven$cvslib$CvsConnection));
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;
    static /* synthetic */ Class class$org$apache$maven$cvslib$CvsConnection;

    public void executeCommand(Command command) throws CommandException, AuthenticationException {
        this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connect(CVSRoot root, String password) throws IllegalArgumentException, AuthenticationException {
        this.connection = ConnectionFactory.getConnection((CVSRoot)root);
        if ("pserver".equals(root.getMethod())) {
            ((PServerConnection)this.connection).setEncodedPassword(password);
        }
        this.connection.open();
        this.client = new Client(this.connection, (AdminHandler)new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
    }

    private void addListener(CVSListener listener) {
        if (this.client != null) {
            this.client.getEventManager().addCVSListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCVSRoot(String workingDir) {
        String root = null;
        BufferedReader r = null;
        if (workingDir == null) {
            workingDir = System.getProperty("user.dir");
        }
        try {
            File f = new File(workingDir);
            File rootFile = new File(f, "CVS/Root");
            if (rootFile.exists()) {
                r = new BufferedReader(new FileReader(rootFile));
                root = r.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
        }
        if (root == null) {
            root = System.getProperty("cvs.root");
        }
        return root;
    }

    private static int processGlobalOptions(String[] args, GlobalOptions globalOptions) {
        String getOptString = globalOptions.getOptString();
        GetOpt go = new GetOpt(args, getOptString);
        int ch = -1;
        boolean usagePrint = false;
        while ((ch = go.getopt()) != -1) {
            boolean success = globalOptions.setCVSCommand((char)ch, go.optArgGet());
            if (success) continue;
            usagePrint = true;
        }
        return go.optIndexGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static String lookupPassword(String cvsRoot) {
        File passFile = new File(System.getProperty("cvs.passfile", System.getProperty("user.home") + "/.cvspass"));
        BufferedReader reader = null;
        String password = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(passFile));
            while ((line = reader.readLine()) != null) {
                void var4_4;
                if (!var4_4.startsWith(cvsRoot)) continue;
                password = var4_4.substring(cvsRoot.length() + 1);
                break;
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Could not read password for host: " + e));
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Warning: could not close password file.");
                }
            }
        }
        if (password == null) {
            LOG.error((Object)("Didn't find password for CVSROOT '" + cvsRoot + "'."));
        }
        return password;
    }

    public static boolean processCommand(String[] args, String localPath, CVSListener listener) throws Exception {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(CvsConnection.getCVSRoot(localPath));
        int commandIndex = -1;
        try {
            commandIndex = CvsConnection.processGlobalOptions(args, globalOptions);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Invalid argument: " + e));
            return false;
        }
        if (globalOptions.getCVSRoot() == null) {
            LOG.error((Object)"No CVS root is set. Check your <repository> information in the POM.");
            return false;
        }
        CVSRoot root = null;
        String cvsRoot = globalOptions.getCVSRoot();
        try {
            root = CVSRoot.parse((String)cvsRoot);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Incorrect format for CVSRoot: " + cvsRoot + "\nThe correct format is: " + "[:method:][[user][:password]@][hostname:[port]]/path/to/repository" + "\nwhere \"method\" is pserver."));
            return false;
        }
        String command = args[commandIndex];
        Command c = null;
        try {
            c = CommandFactory.getDefault().createCommand(command, args, ++commandIndex, globalOptions, localPath);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Illegal argument: " + e.getMessage()));
            return false;
        }
        String password = null;
        if ("pserver".equals(root.getMethod())) {
            password = root.getPassword();
            if (password != null) {
                password = StandardScrambler.getInstance().scramble(password);
            } else {
                password = CvsConnection.lookupPassword(cvsRoot);
                if (password == null) {
                    password = StandardScrambler.getInstance().scramble("");
                }
            }
        }
        CvsConnection cvsCommand = new CvsConnection();
        cvsCommand.setGlobalOptions(globalOptions);
        cvsCommand.setRepository(root.getRepository());
        cvsCommand.setLocalPath(localPath);
        cvsCommand.connect(root, password);
        cvsCommand.addListener(listener);
        cvsCommand.executeCommand(c);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

