/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jxr.DirectoryIndexer;
import org.apache.maven.jxr.JXR;
import org.apache.maven.jxr.pacman.PackageManager;

public class JxrBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$jxr$JxrBean == null ? (class$org$apache$maven$jxr$JxrBean = JxrBean.class$("org.apache.maven.jxr.JxrBean")) : class$org$apache$maven$jxr$JxrBean));
    private List sourceDirs = new LinkedList();
    private String destDir;
    private String javadocDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;
    private String templateDir;
    static /* synthetic */ Class class$org$apache$maven$jxr$JxrBean;

    public void xref() throws Exception {
        String javadocLinkDir = null;
        if (this.javadocDir != null) {
            javadocLinkDir = this.getRelativeLink(this.destDir, this.javadocDir);
        }
        PackageManager pkgmgr = new PackageManager();
        Iterator i = this.sourceDirs.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            path = new File(path).getCanonicalPath();
            pkgmgr.process(path);
            new JXR(pkgmgr, path, this.destDir, javadocLinkDir, "HEAD");
        }
        DirectoryIndexer indexer = new DirectoryIndexer(pkgmgr, this.destDir);
        indexer.setTemplateDir(this.getTemplateDir());
        indexer.setWindowTitle(this.getWindowTitle());
        indexer.setDocTitle(this.getDocTitle());
        indexer.setBottom(this.getBottom());
        indexer.process();
    }

    private String getRelativeLink(String fromDir, String toDir) throws IOException {
        StringBuffer toLink = new StringBuffer();
        StringBuffer fromLink = new StringBuffer();
        LinkedList<File> parents = new LinkedList<File>();
        File f = new File(toDir);
        f = f.getCanonicalFile();
        while (f != null) {
            parents.add(f);
            f = f.getParentFile();
        }
        f = new File(fromDir);
        f = f.getCanonicalFile();
        f = f.getParentFile();
        boolean found = false;
        while (f != null && !found) {
            int i = 0;
            while (i < parents.size()) {
                File parent = (File)parents.get(i);
                if (f.equals(parent)) {
                    int j = 0;
                    while (j < i) {
                        File p = (File)parents.get(j);
                        toLink.insert(0, p.getName() + "/");
                        ++j;
                    }
                    found = true;
                    break;
                }
                ++i;
            }
            f = f.getParentFile();
            fromLink.append("../");
        }
        if (!found) {
            throw new FileNotFoundException(fromDir + " and " + toDir + " have no common parent.");
        }
        return fromLink.append(toLink.toString()).toString();
    }

    public void setSourceDir(String sourceDir) {
        if (!this.sourceDirs.isEmpty()) {
            this.sourceDirs.clear();
        }
        this.addSourceDir(sourceDir);
    }

    public void addSourceDir(String sourceDir) {
        this.sourceDirs.add(sourceDir);
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setJavadocDir(String javadocDir) {
        this.javadocDir = javadocDir;
    }

    public String getJavadocDir() {
        return this.javadocDir;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public String getBottom() {
        return this.bottom;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

