/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanCreateRule
extends Rule {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanCreateRule == null ? (class$org$apache$commons$betwixt$io$BeanCreateRule = BeanCreateRule.class$("org.apache.commons.betwixt.io.BeanCreateRule")) : class$org$apache$commons$betwixt$io$BeanCreateRule));
    private ElementDescriptor descriptor;
    private Context context;
    private boolean addedChildren;
    private boolean createdBean;
    private Class beanClass;
    private String pathPrefix;
    private boolean matchIDs = true;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanCreateRule;

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, String pathPrefix) {
        this(descriptor, beanClass, pathPrefix, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, String pathPrefix, boolean matchIDs) {
        this(descriptor, beanClass, new Context(), pathPrefix, matchIDs);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass) {
        this(descriptor, beanClass, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, boolean matchIDs) {
        this(descriptor, beanClass, descriptor.getQualifiedName() + "/", matchIDs);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Context context, String pathPrefix) {
        this(descriptor, context, pathPrefix, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Context context, String pathPrefix, boolean matchIDs) {
        this(descriptor, descriptor.getSingularPropertyType(), context, pathPrefix, matchIDs);
    }

    private BeanCreateRule(ElementDescriptor descriptor, Class beanClass, Context context, String pathPrefix, boolean matchIDs) {
        this.descriptor = descriptor;
        this.context = context;
        this.beanClass = beanClass;
        this.pathPrefix = pathPrefix;
        this.matchIDs = matchIDs;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Created bean create rule");
            log.trace((Object)("Descriptor=" + descriptor));
            log.trace((Object)("Class=" + beanClass));
            log.trace((Object)("Path prefix=" + pathPrefix));
        }
    }

    public void begin(Attributes attributes) {
        log.debug((Object)("Called with descriptor: " + this.descriptor + " propertyType: " + this.descriptor.getPropertyType()));
        if (log.isTraceEnabled()) {
            int attributesLength = attributes.getLength();
            if (attributesLength > 0) {
                log.trace((Object)"Attributes:");
            }
            int i = 0;
            int size = attributesLength;
            while (i < size) {
                log.trace((Object)("Local:" + attributes.getLocalName(i)));
                log.trace((Object)("URI:" + attributes.getURI(i)));
                log.trace((Object)("QName:" + attributes.getQName(i)));
                ++i;
            }
        }
        this.createdBean = false;
        Object instance = null;
        if (this.beanClass != null && (instance = this.createBean(attributes)) != null) {
            String id;
            this.createdBean = true;
            this.context.setBean(instance);
            this.digester.push(instance);
            ElementDescriptor typeDescriptor = this.getElementDescriptor(this.descriptor);
            AttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributeDescriptors();
            if (attributeDescriptors != null) {
                int i = 0;
                int size = attributeDescriptors.length;
                while (i < size) {
                    AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                    String value = attributes.getValue(attributeDescriptor.getURI(), attributeDescriptor.getLocalName());
                    if (value == null) {
                        value = attributes.getValue(attributeDescriptor.getQualifiedName());
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Attr URL:" + attributeDescriptor.getURI()));
                        log.trace((Object)("Attr LocalName:" + attributeDescriptor.getLocalName()));
                        log.trace((Object)value);
                    }
                    Updater updater = attributeDescriptor.getUpdater();
                    log.trace((Object)updater);
                    if (updater != null && value != null) {
                        updater.update(this.context, value);
                    }
                    ++i;
                }
            }
            this.addChildRules();
            if (this.matchIDs && (id = attributes.getValue("id")) != null) {
                this.getBeansById().put(id, instance);
            }
        }
    }

    public void end() {
        if (this.createdBean) {
            Updater updater = this.descriptor.getUpdater();
            Object instance = this.context.getBean();
            Object top = this.digester.pop();
            if (this.digester.getCount() == 0) {
                this.context.setBean(null);
            } else {
                this.context.setBean(this.digester.peek());
            }
            if (updater != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean()));
                }
                updater.update(this.context, instance);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean()));
            }
        }
    }

    public void finish() {
    }

    protected Object createBean(Attributes attributes) {
        String idref;
        if (this.matchIDs && (idref = attributes.getValue("idref")) != null) {
            log.trace((Object)"Found IDREF");
            Object bean = this.getBeansById().get(idref);
            if (bean != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Matched bean " + bean));
                }
                return bean;
            }
            log.trace((Object)"No match found");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating instance of " + this.beanClass));
            }
            return this.beanClass.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Could not create instance of type: " + this.beanClass.getName()));
            return null;
        }
    }

    protected void addChildRules() {
        if (!this.addedChildren) {
            this.addedChildren = true;
            this.addChildRules(this.pathPrefix, this.descriptor);
        }
    }

    protected void addChildRules(String prefix, ElementDescriptor currentDescriptor) {
        block13: {
            ElementDescriptor typeDescriptor;
            ElementDescriptor[] childDescriptors;
            BeanReader digester = this.getBeanReader();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding child rules for " + currentDescriptor + "@" + prefix));
            }
            if ((childDescriptors = (typeDescriptor = this.getElementDescriptor(currentDescriptor)).getElementDescriptors()) == null) break block13;
            int i = 0;
            int size = childDescriptors.length;
            while (i < size) {
                block15: {
                    String path;
                    ElementDescriptor childDescriptor;
                    block16: {
                        block19: {
                            block17: {
                                int index;
                                block18: {
                                    String qualifiedName;
                                    block14: {
                                        childDescriptor = childDescriptors[i];
                                        if (log.isTraceEnabled()) {
                                            log.trace((Object)("Processing child " + childDescriptor));
                                        }
                                        String propertyName = childDescriptor.getPropertyName();
                                        qualifiedName = childDescriptor.getQualifiedName();
                                        if (qualifiedName != null) break block14;
                                        log.trace((Object)"Ignoring");
                                        break block15;
                                    }
                                    path = prefix + qualifiedName;
                                    if (!qualifiedName.equals(currentDescriptor.getQualifiedName()) || currentDescriptor.getPropertyName() == null) break block16;
                                    log.trace((Object)"Creating generic rule for recursive elements");
                                    index = -1;
                                    if (!childDescriptor.isWrapCollectionsInElement()) break block17;
                                    index = prefix.indexOf(qualifiedName);
                                    if (index != -1) break block18;
                                    log.debug((Object)"Oops - this shouldn't happen");
                                    break block15;
                                }
                                int removeSlash = prefix.endsWith("/") ? 1 : 0;
                                path = "*/" + prefix.substring(index, prefix.length() - removeSlash);
                                break block19;
                            }
                            ElementDescriptor[] desc = currentDescriptor.getElementDescriptors();
                            if (desc.length == 1) {
                                path = "*/" + desc[0].getQualifiedName();
                            }
                        }
                        BeanCreateRule rule = new BeanCreateRule(childDescriptor, this.context, path, this.matchIDs);
                        this.addRule(path, rule);
                        break block15;
                    }
                    if (childDescriptor.getUpdater() != null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Element has updater " + ((MethodUpdater)childDescriptor.getUpdater()).getMethod().getName()));
                        }
                        if (childDescriptor.isPrimitiveType()) {
                            this.addPrimitiveTypeRule(path, childDescriptor);
                        } else {
                            Class beanClass;
                            ElementDescriptor grandChild;
                            String grandChildQName;
                            ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                            if (grandChildren != null && grandChildren.length > 0 && (grandChildQName = (grandChild = grandChildren[0]).getQualifiedName()) != null && grandChildQName.length() > 0) {
                                path = childDescriptor.isWrapCollectionsInElement() ? path + '/' + grandChildQName : prefix + grandChildQName;
                            }
                            if (XMLIntrospectorHelper.isPrimitiveType(beanClass = childDescriptor.getSingularPropertyType())) {
                                this.addPrimitiveTypeRule(path, childDescriptor);
                            } else {
                                BeanCreateRule rule = new BeanCreateRule(childDescriptor, this.context, path + '/', this.matchIDs);
                                this.addRule(path, rule);
                            }
                        }
                    } else {
                        log.trace((Object)"Element does not have updater");
                    }
                    ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                    if (grandChildren != null && grandChildren.length > 0) {
                        log.trace((Object)"Adding grand children");
                        this.addChildRules(path + '/', childDescriptor);
                    }
                }
                ++i;
            }
        }
    }

    protected BeanReader getBeanReader() {
        return (BeanReader)this.getDigester();
    }

    protected ElementDescriptor getElementDescriptor(ElementDescriptor propertyDescriptor) {
        Class beanClass = propertyDescriptor.getSingularPropertyType();
        if (beanClass != null) {
            XMLIntrospector introspector = this.getBeanReader().getXMLIntrospector();
            try {
                XMLBeanInfo xmlInfo = introspector.introspect(beanClass);
                return xmlInfo.getElementDescriptor();
            }
            catch (Exception e) {
                log.warn((Object)("Could not introspect class: " + beanClass), (Throwable)e);
            }
        }
        return propertyDescriptor;
    }

    protected void addPrimitiveTypeRule(String path, final ElementDescriptor childDescriptor) {
        Rule rule = new Rule(){

            public void body(String text) throws Exception {
                childDescriptor.getUpdater().update(BeanCreateRule.this.context, text);
            }
        };
        this.addRule(path, rule);
    }

    protected void addRule(String path, Rule rule) {
        Rules rules = this.digester.getRules();
        List matches = rules.match(null, path);
        if (matches.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding digester rule for path: " + path + " rule: " + rule));
            }
            this.digester.addRule(path, rule);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring duplicate digester rule for path: " + path + " rule: " + rule));
            log.debug((Object)("New rule (not added): " + rule));
            log.debug((Object)("Existing rule:" + matches.get(0)));
        }
    }

    protected Map getBeansById() {
        HashMap beansById = (HashMap)this.context.getVariable("beans-index");
        if (beansById == null) {
            beansById = new HashMap();
            this.context.setVariable("beans-index", beansById);
            log.trace((Object)"Created new index-by-id map");
        }
        return beansById;
    }

    public String toString() {
        return "BeanCreateRule [path prefix=" + this.pathPrefix + " descriptor=" + this.descriptor + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

