/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus;

import com.werken.classworlds.ClassWorld;
import com.werken.classworlds.NoSuchRealmException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.plexus.PlexusContainer;
import org.apache.plexus.classloader.DefaultResourceManager;
import org.apache.plexus.classloader.ResourceManagerFactory;
import org.apache.plexus.configuration.ConfigurationResourceException;
import org.apache.plexus.configuration.XmlPullConfigurationBuilder;
import org.apache.plexus.context.DefaultContext;
import org.apache.plexus.lifecycle.LifecycleHandler;
import org.apache.plexus.lifecycle.LifecycleHandlerFactory;
import org.apache.plexus.logging.AbstractLogEnabled;
import org.apache.plexus.logging.LoggerManager;
import org.apache.plexus.logging.LoggerManagerFactory;
import org.apache.plexus.service.repository.ComponentRepository;
import org.apache.plexus.service.repository.ComponentRepositoryFactory;
import org.apache.plexus.util.ContextMapAdapter;
import org.apache.plexus.util.InterpolationFilterReader;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements PlexusContainer {
    private LoggerManager loggerManager;
    private DefaultContext context;
    private ComponentRepository componentRepository;
    private Configuration configuration;
    private Reader configurationReader;
    private LifecycleHandler lifecycleHandler;
    private ClassWorld classWorld;
    private ClassLoader classLoader;
    private DefaultResourceManager resourceManager;
    private XmlPullConfigurationBuilder builder = new XmlPullConfigurationBuilder();
    private Configuration defaultConfiguration;

    public void setConfigurationResource(Reader configuration) throws ConfigurationResourceException {
        this.setConfigurationReader(configuration);
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(Configuration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("This container must be assigned a ClassLoader.");
        }
        return this.classLoader;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void addContextValue(Object key, Object value) {
        this.getContext().put(key, value);
    }

    public ComponentRepository getComponentRepository() {
        return this.componentRepository;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public void initialize() throws Exception {
        this.initializeClassLoader();
        this.initializeDefaultConfiguration();
        this.initializeConfiguration();
        this.initializeLoggerManager();
        this.initializeComponentRepository();
        this.initializeResourceManager();
        this.initializeContext();
        this.initializeLifecycleHandler();
        this.initializeSystemProperties();
    }

    public void start() throws Exception {
        this.loadOnStart();
    }

    public void dispose() {
    }

    protected void initializeClassLoader() throws Exception {
        if (this.getClassWorld() != null) {
            try {
                this.classLoader = this.getClassWorld().getRealm("core").getClassLoader();
            }
            catch (NoSuchRealmException e) {}
        } else {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    protected void initializeContext() {
        this.addContextValue("common.classloader", this.getClassLoader());
    }

    protected void initializeDefaultConfiguration() throws Exception {
        InputStream is = this.getClassLoader().getResourceAsStream("org/apache/plexus/plexus.conf");
        if (is == null) {
            throw new IllegalStateException("The internal default plexus.conf is missing. This is highly irregular, your plexus JAR is most likely corrupt.");
        }
        this.setDefaultConfiguration(this.builder.parse(new InputStreamReader(is)));
    }

    protected void initializeConfiguration() throws Exception {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(this.getConfigurationReader(), new ContextMapAdapter(this.getContext()));
        this.setConfiguration(this.builder.parse(interpolationFilterReader));
    }

    protected void initializeLoggerManager() throws Exception {
        LoggerManager loggerManager = LoggerManagerFactory.create(this.getDefaultConfiguration(), this.getConfiguration(), this.getClassLoader());
        this.enableLogging(loggerManager.getRootLogger());
        this.setLoggerManager(loggerManager);
    }

    protected void initializeComponentRepository() throws Exception {
        ComponentRepository componentRepository = ComponentRepositoryFactory.create(this.getDefaultConfiguration(), this.getConfiguration(), this.getLoggerManager(), this, this.getClassLoader());
        this.setComponentRepository(componentRepository);
    }

    protected void initializeResourceManager() throws Exception {
        DefaultResourceManager rm = ResourceManagerFactory.create(this.getDefaultConfiguration(), this.getConfiguration(), this.getLoggerManager(), this.getClassLoader());
        this.setResourceManager(rm);
        this.setClassLoader(rm.getPlexusClassLoader());
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
    }

    protected void initializeLifecycleHandler() throws Exception {
        LifecycleHandler lh = LifecycleHandlerFactory.create(this.getDefaultConfiguration(), this.getConfiguration(), this.getLoggerManager(), this.getClassLoader(), this.getContext(), this.getComponentRepository());
        this.setLifecycleHandler(lh);
    }

    protected void initializeSystemProperties() throws Exception {
        Configuration[] systemProperties = this.getConfiguration().getChild("system-properties").getChildren("property");
        int i = 0;
        while (i < systemProperties.length) {
            String name = systemProperties[i].getAttribute("name");
            String value = systemProperties[i].getAttribute("value");
            System.getProperties().setProperty(name, value);
            this.getLogger().info("Setting system property: [ " + name + ", " + value + " ]");
            ++i;
        }
    }

    void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    void setConfigurationReader(Reader configurationReader) {
        this.configurationReader = configurationReader;
    }

    Reader getConfigurationReader() {
        return this.configurationReader;
    }

    void setResourceManager(DefaultResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    DefaultResourceManager getResourceManager() {
        return this.resourceManager;
    }

    void setContext(DefaultContext context) {
        this.context = context;
    }

    DefaultContext getContext() {
        if (this.context == null) {
            this.context = new DefaultContext();
        }
        return this.context;
    }

    void setComponentRepository(ComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }

    void setLifecycleHandler(LifecycleHandler lifecycleHandler) {
        this.lifecycleHandler = lifecycleHandler;
    }

    protected void loadOnStart() throws Exception {
        Configuration[] loadOnStartServices = this.configuration.getChild("load-on-start").getChildren("service");
        int i = 0;
        while (i < loadOnStartServices.length) {
            String role = loadOnStartServices[i].getAttribute("role");
            String id = loadOnStartServices[i].getAttribute("id", "");
            this.getLogger().info("Loading on start [role,id]: [" + role + "," + id + "]");
            try {
                if (id.length() == 0) {
                    this.getComponentRepository().lookup(role);
                } else {
                    this.getComponentRepository().lookup(role, id);
                }
            }
            catch (ServiceException e) {
                this.getLogger().error("Cannot load-on-start " + role, (Throwable)e);
            }
            ++i;
        }
    }
}

