/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus;

import com.werken.classworlds.ClassWorld;
import java.io.File;
import java.io.FileReader;
import org.apache.plexus.DefaultPlexusContainer;

public class PlexusContainerHost
implements Runnable {
    private boolean shouldStop;
    private boolean isStopped;

    public void start(ClassWorld classWorld, String configurationResource) throws Exception {
        DefaultPlexusContainer container = new DefaultPlexusContainer();
        container.setClassWorld(classWorld);
        container.setConfigurationResource(new FileReader(configurationResource));
        container.addContextValue("plexus.home", System.getProperty("plexus.home"));
        container.addContextValue("plexus.work", System.getProperty("plexus.home") + "/work");
        container.addContextValue("plexus.logs", System.getProperty("plexus.home") + "/logs");
        File plexusLogs = new File(System.getProperty("plexus.home") + "/logs");
        if (!plexusLogs.exists()) {
            plexusLogs.mkdirs();
        }
        container.initialize();
        container.start();
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    PlexusContainerHost.this.shutdown();
                }
                catch (Exception e) {}
            }
        }));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            while (!this.shouldStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        PlexusContainerHost plexusContainerHost2 = this;
        synchronized (plexusContainerHost2) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            this.shouldStop = true;
            this.notifyAll();
        }
        PlexusContainerHost plexusContainerHost2 = this;
        synchronized (plexusContainerHost2) {
            while (!this.isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public static void main(String[] args, ClassWorld classWorld) {
        if (args.length != 1) {
            System.err.println("usage: plexus <plexus.conf>");
            System.exit(1);
        }
        try {
            PlexusContainerHost host = new PlexusContainerHost();
            host.start(classWorld, args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

