/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.logging.log4j;

import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.plexus.logging.AbstractLoggerManager;
import org.apache.plexus.logging.log4j.Log4JLogger;

public class Log4JLoggerManager
extends AbstractLoggerManager
implements Configurable,
Initializable,
Startable {
    public static final String LOGGING_TAG = "logging";
    public static final String SINK_TAG = "appender";
    public static final String ID_TAG = "id";
    public static final String TYPE_TAG = "type";
    public static final String THRESHOLD_TAG = "threshold";
    public static final String LAYOUT_TAG = "layout";
    public static final String CONVERSION_PATTERN_TAG = "conversion-pattern";
    public static final String LOGGER_TAG = "logger";
    public static final String SINK_ID_TAG = "appender-id";
    public static final String PRIORITY_TAG = "priority";
    public static final String ROOT_LOGGER_TAG = "root";
    public static final String TYPE_CONFIGURATION_TAG = "type-configuration";
    public static final String FILE_TAG = "file";
    public static final String APPEND_TAG = "append";
    private boolean rootLoggerSet = false;
    private Configuration[] loggerConfigurations;
    private Configuration[] appenderConfigurations;
    private Properties log4JProperties;

    public Properties getLog4JProperties() {
        return this.log4JProperties;
    }

    public void setLog4JProperties(Properties log4JProperties) {
        this.log4JProperties = log4JProperties;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.appenderConfigurations = configuration.getChild(LOGGING_TAG).getChildren(SINK_TAG);
        this.loggerConfigurations = configuration.getChild(LOGGING_TAG).getChildren(LOGGER_TAG);
    }

    public void initialize() throws Exception {
        this.log4JProperties = new Properties();
        int i = 0;
        while (i < this.appenderConfigurations.length) {
            this.log4JProperties.putAll((Map<?, ?>)this.createAppenderProperties(this.appenderConfigurations[i]));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.loggerConfigurations.length) {
            this.log4JProperties.putAll((Map<?, ?>)this.createLoggerProperties(this.loggerConfigurations[i2]));
            ++i2;
        }
        if (!this.rootLoggerSet) {
            this.log4JProperties.putAll((Map<?, ?>)this.createDefaultRootLoggerProperties());
        }
    }

    public void start() throws Exception {
        PropertyConfigurator.configure((Properties)this.log4JProperties);
    }

    public void stop() throws Exception {
    }

    public Properties createDefaultRootLoggerProperties() {
        Properties p = new Properties();
        p.setProperty("log4j.rootLogger", "INFO,console");
        p.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        p.setProperty("log4j.appender.console.threshold", " INFO");
        p.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.console.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        return p;
    }

    Properties createLoggerProperties(Configuration loggerConfiguration) throws ConfigurationException {
        Properties loggerProperties = new Properties();
        String id = loggerConfiguration.getChild(ID_TAG).getValue();
        String appenderId = loggerConfiguration.getChild(SINK_ID_TAG).getValue();
        String priority = loggerConfiguration.getChild(PRIORITY_TAG).getValue();
        if (id.equals(ROOT_LOGGER_TAG)) {
            loggerProperties.setProperty("log4j.rootLogger", priority + "," + appenderId);
            this.rootLoggerSet = true;
        } else {
            loggerProperties.setProperty("log4j.logger", priority + "," + appenderId);
        }
        return loggerProperties;
    }

    Properties createAppenderProperties(Configuration appenderConfiguration) throws ConfigurationException {
        Properties appenderProperties = new Properties();
        String id = appenderConfiguration.getChild(ID_TAG).getValue();
        String type = appenderConfiguration.getChild(TYPE_TAG).getValue();
        Configuration typeConfiguration = appenderConfiguration.getChild(TYPE_CONFIGURATION_TAG);
        String file = typeConfiguration.getChild(FILE_TAG).getValue();
        String append = typeConfiguration.getChild(APPEND_TAG).getValue();
        String threshold = appenderConfiguration.getChild(THRESHOLD_TAG).getValue();
        String layout = appenderConfiguration.getChild(LAYOUT_TAG).getValue();
        String conversionPattern = appenderConfiguration.getChild(CONVERSION_PATTERN_TAG).getValue();
        String base = "log4j.appender." + id;
        if (type.equals("rollingFile")) {
            appenderProperties.setProperty(base, "org.apache.log4j.RollingFileAppender");
            appenderProperties.setProperty(base + ".MaxBackupIndex", typeConfiguration.getChild("maxBackupIndex").getValue());
            appenderProperties.setProperty(base + ".MaxFileSize", typeConfiguration.getChild("maxFileSize").getValue());
        } else {
            appenderProperties.setProperty(base, "org.apache.log4j.FileAppender");
        }
        appenderProperties.setProperty(base + ".file", file);
        appenderProperties.setProperty(base + ".append", append);
        appenderProperties.setProperty(base + ".threshold", threshold);
        appenderProperties.setProperty(base + ".layout", "org.apache.log4j.PatternLayout");
        appenderProperties.setProperty(base + ".layout.conversionPattern", conversionPattern);
        return appenderProperties;
    }

    public org.apache.avalon.framework.logger.Logger getRootLogger() {
        return new Log4JLogger(Logger.getRootLogger());
    }

    public org.apache.avalon.framework.logger.Logger getLogger(String name) {
        return new Log4JLogger(Logger.getLogger((String)name));
    }
}

