/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlExprResolver;
import org.apache.commons.jexl.parser.SimpleNode;

class ExpressionImpl
implements Expression {
    List preResolvers;
    List postResolvers;
    protected String expression;
    protected SimpleNode node;

    ExpressionImpl(String expr, SimpleNode ref) {
        this.expression = expr;
        this.node = ref;
    }

    public Object evaluate(JexlContext context) throws Exception {
        Object val = null;
        if (this.preResolvers != null && (val = this.tryResolver(this.preResolvers, context)) != JexlExprResolver.NO_VALUE) {
            return val;
        }
        val = this.node.value(context);
        if (val == null && this.postResolvers != null && (val = this.tryResolver(this.postResolvers, context)) != JexlExprResolver.NO_VALUE) {
            return val;
        }
        return val;
    }

    protected Object tryResolver(List resolverList, JexlContext context) {
        Object val = JexlExprResolver.NO_VALUE;
        String expr = this.getExpression();
        int i = 0;
        while (i < resolverList.size()) {
            JexlExprResolver jer = (JexlExprResolver)resolverList.get(i);
            val = jer.evaluate(context, expr);
            if (val != JexlExprResolver.NO_VALUE) {
                return val;
            }
            ++i;
        }
        return val;
    }

    public String getExpression() {
        return this.expression;
    }

    public void addPreResolver(JexlExprResolver resolver) {
        if (this.preResolvers == null) {
            this.preResolvers = new ArrayList();
        }
        this.preResolvers.add(resolver);
    }

    public void addPostResolver(JexlExprResolver resolver) {
        if (this.postResolvers == null) {
            this.postResolvers = new ArrayList();
        }
        this.postResolvers.add(resolver);
    }
}

