/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import org.apache.maven.jcoveragereport.Coverage;
import org.apache.maven.jcoveragereport.CoverageReport;
import org.apache.maven.jcoveragereport.CoverageUnmarshaller;

public class CoverageReportGenerator {
    private String dataFile;
    private String outputDir;

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void execute() throws Exception {
        System.out.println("Generate report for " + this.dataFile + " file.");
        System.out.println("OutputDir = " + this.outputDir);
        try {
            this.prepareFile();
            FileReader fr = new FileReader(this.dataFile);
            CoverageUnmarshaller cum = new CoverageUnmarshaller();
            Coverage coverage = cum.parse(fr);
            CoverageReport cr = new CoverageReport(coverage);
            cr.generate(this.outputDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareFile() throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(this.dataFile));
        PrintWriter pw = new PrintWriter(new FileOutputStream(this.dataFile + ".new"));
        while ((line = br.readLine()) != null) {
            void var3_3;
            line = this.replace((String)var3_3, "<init>", "&lt;init&gt;", 0);
            line = this.replace(line, "<clinit>", "&lt;clinit&gt;", 0);
            pw.println(line);
        }
        pw.close();
        br.close();
        File fSrc = new File(this.dataFile);
        File fNew = new File(this.dataFile + ".new");
        fSrc.delete();
        fNew.renameTo(fSrc);
    }

    private String replace(String line, String oldString, String newString, int startAt) {
        int i = startAt;
        while ((i = line.indexOf(oldString, i)) >= 0) {
            line = line.substring(0, i) + newString + line.substring(i + oldString.length());
            i += newString.length();
        }
        return line;
    }
}

