/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.util.HashMap;

public class JavaToHtml {
    private static HashMap reservedWords = new HashMap();
    private static boolean inMultiLineComment = false;
    private static String commentStart = "<span class=\"comment\">";
    private static String commentEnd = "</span>";
    private static String stringStart = "<span class=\"string\">";
    private static String stringEnd = "</span>";
    private static String reservedWordStart = "<span class=\"keyword\">";
    private static String reservedWordEnd = "</span>";

    public static String syntaxHighlight(String line) {
        return JavaToHtml.htmlFilter(line);
    }

    private static String htmlFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        line = JavaToHtml.replace(line, "&", "&#38;");
        line = JavaToHtml.replace(line, "\\\\", "&#92;&#92;");
        line = JavaToHtml.replace(line, "\\\"", "&#92;&#34");
        line = JavaToHtml.replace(line, "<", "&#60;");
        line = JavaToHtml.replace(line, ">", "&#62;");
        return JavaToHtml.multiLineCommentFilter(line);
    }

    private static String multiLineCommentFilter(String line) {
        int index;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (inMultiLineComment && (index = line.indexOf("*/")) > -1 && !JavaToHtml.isInsideString(line, index)) {
            inMultiLineComment = false;
            buf.append(commentStart);
            buf.append(line.substring(0, index));
            buf.append("*/").append(commentEnd);
            if (line.length() > index + 2) {
                buf.append(JavaToHtml.inlineCommentFilter(line.substring(index + 2)));
            }
            return buf.toString();
        }
        if (inMultiLineComment) {
            buf.append(commentStart);
            buf.append(line);
            buf.append(commentEnd);
            return buf.toString();
        }
        index = line.indexOf("/*");
        if (index > -1 && !JavaToHtml.isInsideString(line, index)) {
            inMultiLineComment = true;
            buf.append(JavaToHtml.inlineCommentFilter(line.substring(0, index)));
            buf.append(commentStart).append("/*");
            buf.append(JavaToHtml.multiLineCommentFilter(line.substring(index + 2)));
            buf.append(commentEnd);
            return buf.toString();
        }
        return JavaToHtml.inlineCommentFilter(line);
    }

    private static String inlineCommentFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int index = line.indexOf("//");
        if (index > -1 && !JavaToHtml.isInsideString(line, index)) {
            buf.append(JavaToHtml.stringFilter(line.substring(0, index)));
            buf.append(commentStart);
            buf.append(line.substring(index));
            buf.append(commentEnd);
        } else {
            buf.append(JavaToHtml.stringFilter(line));
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String stringFilter(String line) {
        int tempIndex;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (line.indexOf("\"") <= -1) {
            return JavaToHtml.keywordFilter(line);
        }
        int start = 0;
        int startStringIndex = -1;
        int endStringIndex = -1;
        while ((tempIndex = line.indexOf("\"")) > -1) {
            void var5_5;
            if (startStringIndex == -1) {
                startStringIndex = 0;
                buf.append(JavaToHtml.stringFilter(line.substring(start, (int)var5_5)));
                buf.append(stringStart).append("\"");
                line = line.substring((int)(var5_5 + true));
                continue;
            }
            startStringIndex = -1;
            endStringIndex = var5_5;
            buf.append(line.substring(0, endStringIndex + 1));
            buf.append(stringEnd);
            line = line.substring(endStringIndex + 1);
        }
        buf.append(JavaToHtml.keywordFilter(line));
        return buf.toString();
    }

    private static String keywordFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        HashMap<String, String> usedReservedWords = new HashMap<String, String>();
        int i = 0;
        int startAt = 0;
        StringBuffer temp = new StringBuffer();
        while (i < line.length()) {
            temp.setLength(0);
            char ch = line.charAt(i);
            startAt = i;
            while (i < line.length() && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                temp.append(ch);
                if (++i >= line.length()) continue;
                ch = line.charAt(i);
            }
            String tempString = temp.toString();
            if (reservedWords.containsKey(tempString) && !usedReservedWords.containsKey(tempString)) {
                usedReservedWords.put(tempString, tempString);
                line = JavaToHtml.replace(line, tempString, reservedWordStart + tempString + reservedWordEnd, startAt);
                i += reservedWordStart.length() + reservedWordEnd.length();
                continue;
            }
            ++i;
        }
        buf.append(line);
        return buf.toString();
    }

    private static String replace(String line, String oldString, String newString) {
        return JavaToHtml.replace(line, oldString, newString, 0);
    }

    private static String replace(String line, String oldString, String newString, int startAt) {
        int i = startAt;
        while ((i = line.indexOf(oldString, i)) >= 0) {
            line = line.substring(0, i) + newString + line.substring(i + oldString.length());
            i += newString.length();
        }
        return line;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInsideString(String line, int position) {
        int index;
        if (line.indexOf("\"") < 0) {
            return false;
        }
        String left = line.substring(0, position);
        String right = line.substring(position);
        int leftCount = 0;
        int rightCount = 0;
        while ((index = left.indexOf("\"")) > -1) {
            void var2_6;
            ++leftCount;
            left = left.substring((int)(var2_6 + true));
        }
        while ((index = right.indexOf("\"")) > -1) {
            ++rightCount;
            right = right.substring(index + 1);
        }
        return rightCount % 2 != 0 && leftCount % 2 != 0;
    }

    private static void loadHash() {
        reservedWords.put("abstract", "abstract");
        reservedWords.put("do", "do");
        reservedWords.put("inner", "inner");
        reservedWords.put("public", "public");
        reservedWords.put("var", "var");
        reservedWords.put("boolean", "boolean");
        reservedWords.put("continue", "continue");
        reservedWords.put("int", "int");
        reservedWords.put("return", "return");
        reservedWords.put("void", "void");
        reservedWords.put("break", "break");
        reservedWords.put("else", "else");
        reservedWords.put("interface", "interface");
        reservedWords.put("short", "short");
        reservedWords.put("volatile", "volatile");
        reservedWords.put("byvalue", "byvalue");
        reservedWords.put("extends", "extends");
        reservedWords.put("long", "long");
        reservedWords.put("static", "static");
        reservedWords.put("while", "while");
        reservedWords.put("case", "case");
        reservedWords.put("final", "final");
        reservedWords.put("native", "native");
        reservedWords.put("super", "super");
        reservedWords.put("transient", "transient");
        reservedWords.put("cast", "cast");
        reservedWords.put("float", "float");
        reservedWords.put("new", "new");
        reservedWords.put("rest", "rest");
        reservedWords.put("catch", "catch");
        reservedWords.put("for", "for");
        reservedWords.put("null", "null");
        reservedWords.put("synchronized", "synchronized");
        reservedWords.put("char", "char");
        reservedWords.put("finally", "finally");
        reservedWords.put("operator", "operator");
        reservedWords.put("this", "this");
        reservedWords.put("class", "class");
        reservedWords.put("generic", "generic");
        reservedWords.put("outer", "outer");
        reservedWords.put("switch", "switch");
        reservedWords.put("const", "const");
        reservedWords.put("goto", "goto");
        reservedWords.put("package", "package");
        reservedWords.put("throw", "throw");
        reservedWords.put("double", "double");
        reservedWords.put("if", "if");
        reservedWords.put("private", "private");
        reservedWords.put("true", "true");
        reservedWords.put("default", "default");
        reservedWords.put("import", "import");
        reservedWords.put("protected", "protected");
        reservedWords.put("try", "try");
    }

    static {
        JavaToHtml.loadHash();
    }
}

