/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.compress.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import org.apache.commons.io.compress.zip.ExtraFieldUtils;
import org.apache.commons.io.compress.zip.ZipExtraField;
import org.apache.commons.io.compress.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry {
    private static Method c_setCompressedSizeMethod;
    private static final Object c_lockReflection;
    private static boolean c_triedToGetMethod;
    private final ArrayList m_extraFields = new ArrayList();
    private int m_internalAttributes;
    private long m_externalAttributes;
    private Long m_compressedSize;
    static /* synthetic */ Class class$java$util$zip$ZipEntry;

    public ZipEntry(String name) {
        super(name);
    }

    public ZipEntry(java.util.zip.ZipEntry entry) throws ZipException {
        super(entry.getName());
        byte[] extra;
        long crc;
        long cSize;
        this.setComment(entry.getComment());
        this.setMethod(entry.getMethod());
        this.setTime(entry.getTime());
        long size = entry.getSize();
        if (size > 0L) {
            this.setSize(size);
        }
        if ((cSize = entry.getCompressedSize()) > 0L) {
            this.setComprSize(cSize);
        }
        if ((crc = entry.getCrc()) > 0L) {
            this.setCrc(crc);
        }
        if ((extra = entry.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry entry) throws ZipException {
        this((java.util.zip.ZipEntry)entry);
        this.setInternalAttributes(entry.getInternalAttributes());
        this.setExternalAttributes(entry.getExternalAttributes());
        this.setExtraFields(entry.getExtraFields());
    }

    private static void checkSCS() {
        if (!c_triedToGetMethod) {
            Object object = c_lockReflection;
            synchronized (object) {
                c_triedToGetMethod = true;
                try {
                    c_setCompressedSizeMethod = (class$java$util$zip$ZipEntry == null ? (class$java$util$zip$ZipEntry = ZipEntry.class$("java.util.zip.ZipEntry")) : class$java$util$zip$ZipEntry).getMethod("setCompressedSize", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        return c_setCompressedSizeMethod != null;
    }

    private static void performSetCompressedSize(ZipEntry entry, long size) {
        Object[] s = new Long[]{new Long(size)};
        try {
            c_setCompressedSizeMethod.invoke((Object)entry, s);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            String message = "Exception setting the compressed size of " + entry + ": " + nested.getMessage();
            throw new RuntimeException(message);
        }
        catch (Throwable t) {
            String message = "Exception setting the compressed size of " + entry + ": " + t.getMessage();
            throw new RuntimeException(message);
        }
    }

    public void setComprSize(long size) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, size);
        } else {
            this.m_compressedSize = new Long(size);
        }
    }

    public void setExternalAttributes(long externalAttributes) {
        this.m_externalAttributes = externalAttributes;
    }

    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.m_extraFields.clear();
        int i = 0;
        while (i < fields.length) {
            this.m_extraFields.add(fields[i]);
            ++i;
        }
        this.setExtra();
    }

    public void setInternalAttributes(int value) {
        this.m_internalAttributes = value;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public long getCompressedSize() {
        if (this.m_compressedSize != null) {
            return this.m_compressedSize;
        }
        return super.getCompressedSize();
    }

    public long getExternalAttributes() {
        return this.m_externalAttributes;
    }

    public ZipExtraField[] getExtraFields() {
        ZipExtraField[] result = new ZipExtraField[this.m_extraFields.size()];
        return this.m_extraFields.toArray(result);
    }

    public int getInternalAttributes() {
        return this.m_internalAttributes;
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : new byte[]{};
    }

    public void addExtraField(ZipExtraField extraField) {
        ZipShort type = extraField.getHeaderID();
        boolean done = false;
        int i = 0;
        while (!done && i < this.m_extraFields.size()) {
            ZipExtraField other = (ZipExtraField)this.m_extraFields.get(i);
            if (other.getHeaderID().equals(type)) {
                this.m_extraFields.set(i, extraField);
                done = true;
            }
            ++i;
        }
        if (!done) {
            this.m_extraFields.add(extraField);
        }
        this.setExtra();
    }

    public Object clone() {
        ZipEntry entry = null;
        try {
            entry = new ZipEntry((java.util.zip.ZipEntry)super.clone());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        entry.setInternalAttributes(this.getInternalAttributes());
        entry.setExternalAttributes(this.getExternalAttributes());
        entry.setExtraFields(this.getExtraFields());
        return entry;
    }

    public void removeExtraField(ZipShort type) {
        boolean done = false;
        int i = 0;
        while (!done && i < this.m_extraFields.size()) {
            if (((ZipExtraField)this.m_extraFields.get(i)).getHeaderID().equals(type)) {
                this.m_extraFields.remove(i);
                done = true;
            }
            ++i;
        }
        if (!done) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        c_lockReflection = new Object();
    }
}

