/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.compress.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.compress.zip.ZipEntry;
import org.apache.commons.io.compress.zip.ZipLong;
import org.apache.commons.io.compress.zip.ZipShort;

public class ZipOutputStream
extends DeflaterOutputStream {
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    protected static final ZipLong LFH_SIG = new ZipLong(67324752L);
    protected static final ZipLong DD_SIG = new ZipLong(134695760L);
    protected static final ZipLong CFH_SIG = new ZipLong(33639248L);
    protected static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong DOS_TIME_MIN = new ZipLong(8448L);
    private String m_comment = "";
    private int m_level = -1;
    private int m_method = 8;
    private final ArrayList m_entries = new ArrayList();
    private final CRC32 m_crc = new CRC32();
    private long m_written;
    private long m_dataStart;
    private ZipLong m_cdOffset = new ZipLong(0L);
    private ZipLong m_cdLength = new ZipLong(0L);
    private final Hashtable m_offsets = new Hashtable();
    private String m_encoding;
    private ZipEntry m_entry;

    public ZipOutputStream(OutputStream output) {
        super(output, new Deflater(-1, true));
    }

    protected static ZipLong toDosTime(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (year < 1980) {
            return DOS_TIME_MIN;
        }
        long value = year - 1980 << 25 | month << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        return new ZipLong(result);
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public void setLevel(int level) {
        this.m_level = level;
    }

    public void setMethod(int method) {
        this.m_method = method;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void closeEntry() throws IOException {
        if (this.m_entry == null) {
            return;
        }
        long realCrc = this.m_crc.getValue();
        this.m_crc.reset();
        if (this.m_entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.m_entry.setSize(this.def.getTotalIn());
            this.m_entry.setComprSize(this.def.getTotalOut());
            this.m_entry.setCrc(realCrc);
            this.def.reset();
            this.m_written += this.m_entry.getCompressedSize();
        } else {
            if (this.m_entry.getCrc() != realCrc) {
                throw new ZipException("bad CRC checksum for entry " + this.m_entry.getName() + ": " + Long.toHexString(this.m_entry.getCrc()) + " instead of " + Long.toHexString(realCrc));
            }
            if (this.m_entry.getSize() != this.m_written - this.m_dataStart) {
                throw new ZipException("bad size for entry " + this.m_entry.getName() + ": " + this.m_entry.getSize() + " instead of " + (this.m_written - this.m_dataStart));
            }
        }
        this.writeDataDescriptor(this.m_entry);
        this.m_entry = null;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.m_cdOffset = new ZipLong(this.m_written);
        int size = this.m_entries.size();
        int i = 0;
        while (i < size) {
            ZipEntry entry = (ZipEntry)this.m_entries.get(i);
            this.writeCentralFileHeader(entry);
            ++i;
        }
        this.m_cdLength = new ZipLong(this.m_written - this.m_cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.m_offsets.clear();
        this.m_entries.clear();
    }

    public void putNextEntry(ZipEntry entry) throws IOException {
        this.closeEntry();
        this.m_entry = entry;
        this.m_entries.add(this.m_entry);
        if (this.m_entry.getMethod() == -1) {
            this.m_entry.setMethod(this.m_method);
        }
        if (this.m_entry.getTime() == -1L) {
            this.m_entry.setTime(System.currentTimeMillis());
        }
        if (this.m_entry.getMethod() == 0) {
            if (this.m_entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method");
            }
            if (this.m_entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method");
            }
            this.m_entry.setComprSize(this.m_entry.getSize());
        } else {
            this.def.setLevel(this.m_level);
        }
        this.writeLocalFileHeader(this.m_entry);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.m_entry.getMethod() == 8) {
            super.write(buffer, offset, length);
        } else {
            this.out.write(buffer, offset, length);
            this.m_written += (long)length;
        }
        this.m_crc.update(buffer, offset, length);
    }

    protected byte[] getBytes(String name) throws ZipException {
        if (this.m_encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.out.write(EOCD_SIG.getBytes());
        this.out.write(ZERO);
        this.out.write(ZERO);
        byte[] num = new ZipShort(this.m_entries.size()).getBytes();
        this.out.write(num);
        this.out.write(num);
        this.out.write(this.m_cdLength.getBytes());
        this.out.write(this.m_cdOffset.getBytes());
        byte[] data = this.getBytes(this.m_comment);
        this.out.write(new ZipShort(data.length).getBytes());
        this.out.write(data);
    }

    protected void writeCentralFileHeader(ZipEntry entry) throws IOException {
        this.out.write(CFH_SIG.getBytes());
        this.m_written += 4L;
        this.out.write(new ZipShort(20).getBytes());
        this.m_written += 2L;
        if (entry.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.m_written += 4L;
        this.out.write(new ZipShort(entry.getMethod()).getBytes());
        this.m_written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(entry.getTime())).getBytes());
        this.m_written += 4L;
        this.out.write(new ZipLong(entry.getCrc()).getBytes());
        this.out.write(new ZipLong(entry.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(entry.getSize()).getBytes());
        this.m_written += 12L;
        byte[] name = this.getBytes(entry.getName());
        this.out.write(new ZipShort(name.length).getBytes());
        this.m_written += 2L;
        byte[] extra = entry.getCentralDirectoryExtra();
        this.out.write(new ZipShort(extra.length).getBytes());
        this.m_written += 2L;
        String comm = entry.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] comment = this.getBytes(comm);
        this.out.write(new ZipShort(comment.length).getBytes());
        this.m_written += 2L;
        this.out.write(ZERO);
        this.m_written += 2L;
        this.out.write(new ZipShort(entry.getInternalAttributes()).getBytes());
        this.m_written += 2L;
        this.out.write(new ZipLong(entry.getExternalAttributes()).getBytes());
        this.m_written += 4L;
        this.out.write(((ZipLong)this.m_offsets.get(entry)).getBytes());
        this.m_written += 4L;
        this.out.write(name);
        this.m_written += (long)name.length;
        this.out.write(extra);
        this.m_written += (long)extra.length;
        this.out.write(comment);
        this.m_written += (long)comment.length;
    }

    protected void writeDataDescriptor(ZipEntry ze) throws IOException {
        if (ze.getMethod() != 8) {
            return;
        }
        this.out.write(DD_SIG.getBytes());
        this.out.write(new ZipLong(this.m_entry.getCrc()).getBytes());
        this.out.write(new ZipLong(this.m_entry.getCompressedSize()).getBytes());
        this.out.write(new ZipLong(this.m_entry.getSize()).getBytes());
        this.m_written += 16L;
    }

    protected void writeLocalFileHeader(ZipEntry entry) throws IOException {
        this.m_offsets.put(entry, new ZipLong(this.m_written));
        this.out.write(LFH_SIG.getBytes());
        this.m_written += 4L;
        if (entry.getMethod() == 8) {
            this.out.write(new ZipShort(20).getBytes());
            this.out.write(new ZipShort(8).getBytes());
        } else {
            this.out.write(new ZipShort(10).getBytes());
            this.out.write(ZERO);
        }
        this.m_written += 4L;
        this.out.write(new ZipShort(entry.getMethod()).getBytes());
        this.m_written += 2L;
        this.out.write(ZipOutputStream.toDosTime(new Date(entry.getTime())).getBytes());
        this.m_written += 4L;
        if (entry.getMethod() == 8) {
            this.out.write(LZERO);
            this.out.write(LZERO);
            this.out.write(LZERO);
        } else {
            this.out.write(new ZipLong(entry.getCrc()).getBytes());
            this.out.write(new ZipLong(entry.getSize()).getBytes());
            this.out.write(new ZipLong(entry.getSize()).getBytes());
        }
        this.m_written += 12L;
        byte[] name = this.getBytes(entry.getName());
        this.out.write(new ZipShort(name.length).getBytes());
        this.m_written += 2L;
        byte[] extra = entry.getLocalFileDataExtra();
        this.out.write(new ZipShort(extra.length).getBytes());
        this.m_written += 2L;
        this.out.write(name);
        this.m_written += (long)name.length;
        this.out.write(extra);
        this.m_written += (long)extra.length;
        this.m_dataStart = this.m_written;
    }
}

