/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.codeswitcher;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private List onSwitches = new ArrayList();
    private List offSwitches = new ArrayList();
    private List switches = new ArrayList();
    private static final int MAX_LINELENGTH = 82;
    private String[] files;

    public void execute() {
        System.out.println("On Switches");
        System.out.println(this.onSwitches);
        System.out.println("Off Switches");
        System.out.println(this.offSwitches);
        this.process();
    }

    public void setOnSwitches(String onSwitchesCSV) {
        String[] onSwitchesArray = StringUtils.split((String)onSwitchesCSV, (String)",");
        int i = 0;
        while (i < onSwitchesArray.length) {
            this.onSwitches.add(onSwitchesArray[i]);
            ++i;
        }
    }

    public void setOffSwitches(String offSwitchesCSV) {
        String[] offSwitchesArray = StringUtils.split((String)offSwitchesCSV, (String)",");
        int i = 0;
        while (i < offSwitchesArray.length) {
            this.offSwitches.add(offSwitchesArray[i]);
            ++i;
        }
    }

    public void setDirectory(String directory) {
        this.files = this.getFiles(new File(directory), "**/*.java");
    }

    private void process() {
        int i = 0;
        while (i < this.files.length) {
            System.out.print(".");
            String file = this.files[i];
            if (!this.processFile(file)) {
                System.out.println("in file " + file + " !");
            }
            ++i;
        }
        System.out.println("");
    }

    private boolean isLongline(String s) {
        char c = s.charAt(s.length() - 1);
        return ",(+-&|".indexOf(c) >= 0;
    }

    private boolean processFile(String name) {
        File f = new File(name);
        File fnew = new File(name + ".new");
        int state = 0;
        boolean switchoff = false;
        boolean working = false;
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            while ((line = read.readLine()) != null) {
                if (working && (line.equals("/*") || line.equals("*/"))) continue;
                if (!line.startsWith("//#")) {
                    write.write(line + ls);
                    continue;
                }
                if (line.startsWith("//#ifdef ")) {
                    if (state != 0) {
                        this.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    write.write(line + ls);
                    state = 1;
                    String s = line.substring(9);
                    if (this.onSwitches.indexOf(s) != -1) {
                        working = true;
                        switchoff = false;
                    } else if (this.offSwitches.indexOf(s) != -1) {
                        working = true;
                        write.write("/*" + ls);
                        switchoff = true;
                    }
                    if (this.switches.indexOf(s) != -1) continue;
                    this.switches.add(s);
                    continue;
                }
                if (line.startsWith("//#else")) {
                    if (state != 1) {
                        this.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    state = 2;
                    if (!working) {
                        write.write(line + ls);
                        continue;
                    }
                    if (switchoff) {
                        write.write("*/" + ls);
                        write.write(line + ls);
                        switchoff = false;
                        continue;
                    }
                    write.write(line + ls);
                    write.write("/*" + ls);
                    switchoff = true;
                    continue;
                }
                if (line.startsWith("//#endif")) {
                    if (state == 0) {
                        this.printError("'#endif' without '#ifdef'");
                        return false;
                    }
                    state = 0;
                    if (working && switchoff) {
                        write.write("*/" + ls);
                    }
                    write.write(line + ls);
                    working = false;
                    continue;
                }
                write.write(line + ls);
            }
            if (state != 0) {
                this.printError("'#endif' missing");
                return false;
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
            return true;
        }
        catch (Exception e) {
            this.printError(e.getMessage());
            return false;
        }
    }

    int testFile(String name) {
        File f = new File(name);
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            int l = 1;
            int maxline = 0;
            boolean longline = false;
            while ((line = read.readLine()) != null) {
                if (line.length() > 82 && !line.startsWith("org.hsqldb.test.Profile.")) {
                    System.out.println("long line in " + name + " at line " + l);
                }
                if (line.startsWith(" ")) {
                    int spaces = 0;
                    while (spaces < line.length()) {
                        if (line.charAt(spaces) != ' ') break;
                        ++spaces;
                    }
                    if (spaces > 3 && this.testLine(line) && !longline) {
                        ++maxline;
                    } else {
                        longline = this.isLongline(line);
                    }
                    String s = line.substring(spaces);
                    if (s.startsWith("if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("if( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("} else if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("} else if without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("while(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("while( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("switch(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("switch( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("do ") && !s.endsWith(" {")) {
                        System.out.println("do without { in " + name + " at line " + l);
                    }
                }
                ++l;
            }
            read.close();
            return maxline;
        }
        catch (Exception e) {
            this.printError(e.getMessage());
            return -1;
        }
    }

    private boolean testLine(String line) {
        if (!line.endsWith(";")) {
            return false;
        }
        return !line.trim().startsWith("super(");
    }

    private void printError(String error) {
        System.out.println("");
        System.out.println("ERROR: " + error);
    }

    public String[] getFiles(File directory, String includes) {
        String[] includePatterns = null;
        if (includes != null) {
            includePatterns = StringUtils.split((String)includes, (String)",");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setIncludes(includePatterns);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            files[i] = new File(directory, files[i]).getAbsolutePath();
            ++i;
        }
        return files;
    }
}

