/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.algorithm.path;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.algorithm.path.AllPairsShortestPath;
import org.apache.commons.graph.algorithm.path.PathIterator;
import org.apache.commons.graph.algorithm.path.PathListener;
import org.apache.commons.graph.algorithm.util.PathImpl;
import org.apache.commons.graph.algorithm.util.VertexPair;

public class AllPaths {
    private Map allPaths = new HashMap();
    private AllPairsShortestPath apsp = null;
    private DirectedGraph graph = null;

    public AllPaths(DirectedGraph graph) {
        this.graph = graph;
        try {
            this.apsp = new AllPairsShortestPath(graph);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Iterator findPaths(final Vertex i, final Vertex j) {
        final PathIterator RC = new PathIterator();
        Runnable run = new Runnable(){

            public void run() {
                AllPaths.this.findPaths(RC, i, j, Integer.MAX_VALUE);
            }
        };
        Thread thread = new Thread(run);
        RC.setThread(thread);
        thread.start();
        return RC;
    }

    public void findPaths(PathListener listener, Vertex i, Vertex j, int maxLength) {
        HashSet<PathImpl> workingSet = new HashSet<PathImpl>();
        workingSet.add(new PathImpl(i));
        int k = 0;
        while (k < maxLength) {
            Iterator workingPaths = workingSet.iterator();
            if (!workingPaths.hasNext()) break;
            HashSet<PathImpl> newWorkingSet = new HashSet<PathImpl>();
            while (workingPaths.hasNext()) {
                PathImpl workingPath = (PathImpl)workingPaths.next();
                Iterator outbound = this.graph.getOutbound(workingPath.getEnd()).iterator();
                while (outbound.hasNext()) {
                    Edge obEdge = (Edge)outbound.next();
                    if (!this.apsp.hasPath(this.graph.getTarget(obEdge), j)) continue;
                    PathImpl path = workingPath.append(this.graph.getTarget(obEdge), obEdge);
                    newWorkingSet.add(path);
                    if (path.getEnd() != j) continue;
                    listener.notifyPath(path);
                }
            }
            workingSet = newWorkingSet;
            ++k;
        }
    }

    public Set getAllPaths(Vertex i, Vertex j) {
        HashSet<PathImpl> RC = new HashSet<PathImpl>();
        VertexPair key = new VertexPair(i, j);
        if (this.allPaths.containsKey(key)) {
            return (Set)this.allPaths.get(key);
        }
        this.allPaths.put(key, RC);
        Iterator outbounds = this.graph.getOutbound(i).iterator();
        while (outbounds.hasNext()) {
            Edge outbound = (Edge)outbounds.next();
            if (this.graph.getTarget(outbound) != j) continue;
            RC.add(new PathImpl(i, j, outbound));
        }
        Iterator ks = this.graph.getVertices().iterator();
        while (ks.hasNext()) {
            Vertex k = (Vertex)ks.next();
            if (k == i || k == j) continue;
            this.appendPaths(RC, this.getAllPaths(i, k), this.getAllPaths(k, j));
        }
        this.allPaths.put(key, RC);
        return RC;
    }

    public void appendPaths(Set RC, Set iks, Set kjs) {
        Iterator ikPaths = iks.iterator();
        while (ikPaths.hasNext()) {
            PathImpl ik = (PathImpl)ikPaths.next();
            Iterator kjPaths = kjs.iterator();
            while (kjPaths.hasNext()) {
                PathImpl kj = (PathImpl)kjPaths.next();
                RC.add(ik.append(kj));
            }
        }
    }
}

