/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.algorithm.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.algorithm.search.Visitor;

public class DFS {
    private Map colors = new HashMap();
    public static final String WHITE = "white";
    public static final String BLACK = "black";
    public static final String GRAY = "gray";

    public String getColor(Vertex v) {
        return (String)this.colors.get(v);
    }

    private void visitEdge(DirectedGraph graph, Edge e, Visitor visitor) {
        visitor.discoverEdge(e);
        Vertex v = graph.getTarget(e);
        if (this.colors.get(v) == WHITE) {
            this.visitVertex(graph, v, visitor);
        }
        visitor.finishEdge(e);
    }

    private void visitVertex(DirectedGraph graph, Vertex v, Visitor visitor) {
        this.colors.remove(v);
        this.colors.put(v, GRAY);
        visitor.discoverVertex(v);
        Iterator edges = graph.getOutbound(v).iterator();
        while (edges.hasNext()) {
            Edge e = (Edge)edges.next();
            this.visitEdge(graph, e, visitor);
        }
        visitor.finishVertex(v);
        this.colors.remove(v);
        this.colors.put(v, BLACK);
    }

    public void visit(DirectedGraph graph, Vertex root, Visitor visitor) {
        Iterator vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            this.colors.put(vertices.next(), WHITE);
        }
        visitor.discoverGraph(graph);
        this.visitVertex(graph, root, visitor);
        visitor.finishGraph(graph);
    }

    public void visit(DirectedGraph graph, Visitor visitor) {
        Iterator vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            this.colors.put(vertices.next(), WHITE);
        }
        visitor.discoverGraph(graph);
        vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            Vertex v = (Vertex)vertices.next();
            if (this.colors.get(v) != WHITE) continue;
            this.visitVertex(graph, v, visitor);
        }
        visitor.finishGraph(graph);
    }
}

