/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.algorithm.spanning;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BinaryHeap;
import org.apache.commons.collections.PriorityQueue;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Graph;
import org.apache.commons.graph.UndirectedGraph;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.algorithm.util.Label;
import org.apache.commons.graph.decorator.DDirectedGraph;
import org.apache.commons.graph.domain.basic.UndirectedGraphImpl;
import org.apache.commons.graph.exception.HyperGraphException;

public class MinimumSpanningForest
extends UndirectedGraphImpl
implements UndirectedGraph,
WeightedGraph {
    private PriorityQueue queue = null;
    private Map labels = new HashMap();
    private Set chords = new HashSet();
    private DDirectedGraph ddg = null;

    public MinimumSpanningForest(WeightedGraph graph) {
        this.calculateMSF(true, graph);
    }

    public MinimumSpanningForest(boolean isMin, WeightedGraph graph) {
        this.calculateMSF(isMin, graph);
    }

    protected Label findLabel(Vertex v) {
        return (Label)this.labels.get(v);
    }

    protected boolean connectsLabels(Graph graph, Edge e) {
        Label first = null;
        Label second = null;
        Iterator vertices = graph.getVertices(e).iterator();
        if (!vertices.hasNext()) {
            return false;
        }
        first = this.findLabel((Vertex)vertices.next());
        if (!vertices.hasNext()) {
            return false;
        }
        second = this.findLabel((Vertex)vertices.next());
        if (vertices.hasNext()) {
            throw new HyperGraphException("Unable to compute MSF on Hypergraph.");
        }
        return !first.getRoot().equals(second.getRoot());
    }

    protected void addEdge(WeightedGraph graph, Edge edge) {
        this.addEdge(edge);
        this.chords.remove(edge);
        Iterator vertices = graph.getVertices(edge).iterator();
        Label prime = null;
        if (vertices.hasNext()) {
            Vertex p = (Vertex)vertices.next();
            prime = this.findLabel(p);
            this.connect(edge, p);
        }
        while (vertices.hasNext()) {
            Vertex v = (Vertex)vertices.next();
            Label l = this.findLabel(v);
            l.setRoot(prime);
            this.connect(edge, v);
        }
        this.setWeight(edge, graph.getWeight(edge));
    }

    protected void calculateMSF(boolean isMin, WeightedGraph graph) {
        BinaryHeap queue = new BinaryHeap(isMin, (Comparator)new WeightedEdgeComparator(graph));
        this.chords = new HashSet(graph.getEdges());
        Iterator edges = graph.getEdges().iterator();
        while (edges.hasNext()) {
            queue.insert(edges.next());
        }
        Iterator vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            Vertex v = (Vertex)vertices.next();
            this.labels.put(v, new Label());
            this.addVertex(v);
        }
        while (!queue.isEmpty()) {
            Edge e = (Edge)queue.pop();
            if (!this.connectsLabels(graph, e)) continue;
            this.addEdge(graph, e);
        }
    }

    public Set getChords() {
        return this.chords;
    }

    public class WeightedEdgeComparator
    implements Comparator {
        private WeightedGraph graph = null;

        public WeightedEdgeComparator(WeightedGraph graph) {
            this.graph = graph;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Edge && o2 instanceof Edge) {
                double val = this.graph.getWeight((Edge)o1) - this.graph.getWeight((Edge)o2);
                if (val > 0.0) {
                    return 1;
                }
                if (val == 0.0) {
                    return 0;
                }
                if (val < 0.0) {
                    return -1;
                }
            }
            return -1;
        }
    }
}

