/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.BinaryHeap;
import org.apache.commons.collections.PriorityQueue;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.search.Visitor;

public class CostSearch {
    private Map colors = new HashMap();
    private PriorityQueue tasks = null;
    private String WHITE = "white";
    private String BLACK = "black";
    private String GRAY = "gray";

    public CostSearch() {
        this.tasks = new BinaryHeap(true);
    }

    public CostSearch(boolean isMin) {
        this.tasks = new BinaryHeap(isMin);
    }

    public void visitVertex(WeightedGraph graph, Vertex vertex, double cost, Visitor visitor) {
        this.colors.remove(vertex);
        this.colors.put(vertex, this.GRAY);
        visitor.discoverVertex(vertex);
        Iterator edges = graph.getEdges(vertex).iterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            double edgeCost = graph.getWeight(edge);
            ComparableEdge wEdge = new ComparableEdge(edge, edgeCost + cost);
            this.tasks.insert((Object)wEdge);
        }
        visitor.finishVertex(vertex);
        this.colors.remove(vertex);
        this.colors.put(vertex, this.BLACK);
    }

    public void visitEdge(WeightedGraph graph, Edge e, double cost, Visitor visitor) {
        visitor.discoverEdge(e);
        Iterator vertices = graph.getVertices(e).iterator();
        while (vertices.hasNext()) {
            Vertex v = (Vertex)vertices.next();
            if (this.colors.get(v) != this.WHITE) continue;
            this.visitVertex(graph, v, cost, visitor);
        }
        visitor.finishEdge(e);
    }

    public void visit(WeightedGraph graph, Vertex root, Visitor visitor) {
        Iterator vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            this.colors.put(vertices.next(), this.WHITE);
        }
        visitor.discoverGraph(graph);
        this.visitVertex(graph, root, 0.0, visitor);
        while (!this.tasks.isEmpty()) {
            ComparableEdge wEdge = (ComparableEdge)this.tasks.pop();
            this.visitEdge(graph, wEdge.getEdge(), wEdge.getCost(), visitor);
        }
        visitor.finishGraph(graph);
    }

    public class ComparableVertex
    implements Vertex,
    Comparable {
        private Vertex v;
        private double cost;

        public ComparableVertex(Vertex v, double cost) {
            this.v = v;
            this.cost = cost;
        }

        public int compareTo(Object o) {
            ComparableVertex cv = (ComparableVertex)o;
            if (cv.cost > this.cost) {
                return 1;
            }
            if (cv.cost == this.cost) {
                return 0;
            }
            if (cv.cost < this.cost) {
                return -1;
            }
            return 0;
        }

        public Vertex getVertex() {
            return this.v;
        }
    }

    public class ComparableEdge
    implements Edge,
    Comparable {
        private Edge e;
        private double cost;

        public ComparableEdge(Edge e, double cost) {
            this.e = e;
            this.cost = cost;
        }

        public Edge getEdge() {
            return this.e;
        }

        public double getCost() {
            return this.cost;
        }

        public int compareTo(Object o) {
            ComparableVertex cv = (ComparableVertex)o;
            if (cv.cost > this.cost) {
                return 1;
            }
            if (cv.cost == this.cost) {
                return 0;
            }
            if (cv.cost < this.cost) {
                return -1;
            }
            return 0;
        }
    }
}

