/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.visualize;

import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Named;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.visualize.Colored;

public class TouchGraph {
    private Color vertexColor = Color.yellow;
    private Color textColor = Color.black;
    private Color edgeColor = Color.red;
    private double lengthFactor = 500.0;
    private double defaultLength = 1.0;
    private int fontSize = 18;
    private Random random = new Random();

    private String getColorText(Color color) {
        String RC = Integer.toHexString(color.getRGB()).toUpperCase();
        return RC.substring(2, 8);
    }

    public void setVertexColor(Color vertexColor) {
        this.vertexColor = vertexColor;
    }

    public Color getVertexColor() {
        return this.vertexColor;
    }

    private String getVertexColorText() {
        return this.getColorText(this.getVertexColor());
    }

    public void setTextColor(Color vertexColor) {
        this.vertexColor = vertexColor;
    }

    public Color getTextColor() {
        return this.vertexColor;
    }

    private String getTextColorText() {
        return this.getColorText(this.getTextColor());
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    private String getEdgeColorText() {
        return this.getColorText(this.getEdgeColor());
    }

    public void setFontSize(int size) {
        this.fontSize = size;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setDefaultEdgeLength(int length) {
        this.defaultLength = length;
    }

    public double getDefaultEdgeLength() {
        return this.defaultLength;
    }

    protected void writeNodeset(PrintWriter pw, DirectedGraph graph) {
        pw.println("<NODESET>");
        Iterator vertices = graph.getVertices().iterator();
        while (vertices.hasNext()) {
            Vertex v = (Vertex)vertices.next();
            pw.println("<NODE nodeID=\"" + v.toString() + "\">");
            pw.println("<NODE_LOCATION x=\"" + this.random.nextInt(200) + "\" y = \"" + this.random.nextInt(200) + "\" visible=\"true\" />");
            String label = v instanceof Named ? ((Named)((Object)v)).getName() : v.toString();
            String backColor = null;
            String textColor = null;
            if (v instanceof Colored) {
                backColor = this.getColorText(((Colored)((Object)v)).getBackgroundColor());
                textColor = this.getColorText(((Colored)((Object)v)).getTextColor());
            } else {
                backColor = this.getVertexColorText();
                textColor = this.getTextColorText();
            }
            pw.println("<NODE_LABEL label=\"" + label + "\" " + "shape=\"2\" " + "backColor=\"" + backColor + "\" " + "textColor=\"" + textColor + "\" " + "fontSize=\"" + this.fontSize + "\" />");
            pw.println("</NODE>");
        }
        pw.println("</NODESET>");
    }

    protected void writeEdgeset(PrintWriter pw, DirectedGraph graph) {
        pw.println("<EDGESET>");
        Iterator edges = graph.getEdges().iterator();
        while (edges.hasNext()) {
            Edge next = (Edge)edges.next();
            int length = new Double(this.lengthFactor * this.defaultLength).intValue();
            if (graph instanceof WeightedGraph) {
                length = new Double(this.lengthFactor * ((WeightedGraph)((Object)graph)).getWeight(next)).intValue();
            }
            pw.println("<EDGE fromID=\"" + graph.getSource(next) + "\" " + "toID=\"" + graph.getTarget(next) + "\" " + "type=\"2\" " + "visible=\"true\" " + "length=\"" + length + "\" />");
        }
        pw.println("</EDGESET>");
    }

    public void toXML(DirectedGraph graph, OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        pw.println("<?xml version=\"1.0\"?>");
        pw.println("<TOUCHGRAPH_LB version=\"1.20\">");
        this.writeNodeset(pw, graph);
        this.writeEdgeset(pw, graph);
        pw.println("</TOUCHGRAPH_LB>");
        pw.flush();
    }
}

