/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.graph.domain.dependency.DependencyGraph;
import org.apache.maven.jelly.tags.maven.DependencyResolverInterface;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;

public class GraphDependencyResolver
implements DependencyResolverInterface {
    private DependencyGraph dependencyGraph = new DependencyGraph();
    private List projects = new ArrayList();
    private boolean graphBuilt = false;

    public void clear() {
        this.graphBuilt = false;
        this.projects.clear();
    }

    public void setProjects(List projects) {
        this.projects = projects;
    }

    public List getSortedDependencies(Project project) throws Exception {
        return this.getSortedDependencies(project, false);
    }

    public List getSortedDependencies(Project project, boolean sourceBuild) throws Exception {
        this.buildGraph();
        List sortedDependencies = this.dependencyGraph.getSortedDependencies((Object)project);
        if (sourceBuild) {
            return sortedDependencies;
        }
        return this.getBinaryDependencies(sortedDependencies);
    }

    public List getSortedDependencies(boolean sourceBuild) throws Exception {
        this.buildGraph();
        List sortedDependencies = this.dependencyGraph.getSortedDependencies();
        if (sourceBuild) {
            return sortedDependencies;
        }
        return this.getBinaryDependencies(sortedDependencies);
    }

    private List getBinaryDependencies(List sortedDependencies) {
        HashMap<String, Project> idMap = new HashMap<String, Project>();
        Iterator i = this.projects.iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            idMap.put(p.getId(), p);
        }
        ArrayList<Project> binaryDeps = new ArrayList<Project>();
        Iterator i2 = sortedDependencies.iterator();
        while (i2.hasNext()) {
            Project p = (Project)i2.next();
            Project dep = (Project)idMap.get(p.getId());
            if (dep == null) continue;
            binaryDeps.add(dep);
        }
        return binaryDeps;
    }

    private void buildGraph() {
        if (this.graphBuilt) {
            return;
        }
        Iterator i = this.projects.iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            ArrayList<Project> dependencies = new ArrayList<Project>();
            Iterator j = p.getDependencies().iterator();
            while (j.hasNext()) {
                Dependency d = (Dependency)j.next();
                Project dependentProject = new Project();
                dependentProject.setId(d.getId());
                dependencies.add(dependentProject);
            }
            this.dependencyGraph.addDependencies((Object)p, dependencies);
        }
        this.graphBuilt = true;
    }
}

