/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.tags.maven.DependencyResolver;
import org.apache.maven.jelly.tags.maven.MavenTag;
import org.apache.maven.project.Project;

public class ReactorTag
extends MavenTag {
    private String glob;
    private String includes;
    private String excludes;
    private String banner;
    private File basedir;
    private File reactorXml;
    private boolean postProcessing = false;
    private Collection failedProjects = new ArrayList();
    private ArrayList reactorProjects = new ArrayList();

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setPostProcessing(boolean postProcessing) {
        this.postProcessing = postProcessing;
    }

    public boolean getPostProcessing() {
        return this.postProcessing;
    }

    public void setGlob(String glob) {
        System.out.println("\nDEPRECATION WARNING: use the 'includes' attribute instead of the 'glob' attribute.\n");
        this.glob = glob;
    }

    public String getGlob() {
        return this.glob;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getBanner() {
        if (this.banner == null) {
            this.banner = "Processing";
        }
        return this.banner;
    }

    public void setReactorXml(File reactorXml) {
        this.reactorXml = reactorXml;
    }

    public File getReactorXml() {
        return this.reactorXml;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.getBasedir(), "basedir");
        if (this.getGlob() == null && this.getIncludes() == null) {
            throw new MissingAttributeException("glob|includes");
        }
        String projectIncludes = this.getGlob() != null ? this.getGlob() : this.getIncludes();
        System.out.println("Starting the reactor...");
        List projects = null;
        try {
            projects = MavenUtils.getProjects(this.getBasedir(), projectIncludes, this.getExcludes(), this.getMavenContext().getMavenSession().getRootContext());
        }
        catch (Exception anException) {
            throw new JellyTagException("error getting projects", (Throwable)anException);
        }
        DependencyResolver dr = new DependencyResolver();
        dr.setProjects(projects);
        List sortedProjects = null;
        try {
            sortedProjects = dr.getSortedDependencies(false);
        }
        catch (Exception anException) {
            this.onDependencyResolutionException(anException);
            throw new JellyTagException((Throwable)anException);
        }
        dr = null;
        projects = null;
        System.out.println("Our processing order:");
        Iterator i = sortedProjects.iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            System.out.println(p.getName());
        }
        Runtime r = Runtime.getRuntime();
        Iterator i2 = sortedProjects.iterator();
        while (i2.hasNext()) {
            Project project;
            block15: {
                project = (Project)i2.next();
                this.beforeProject(project);
                try {
                    long MEG = 0x100000L;
                    System.out.println("+----------------------------------------");
                    System.out.println("| " + this.getBanner() + " " + project.getName());
                    System.out.println("| Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M");
                    System.out.println("+----------------------------------------");
                    if (this.getReactorXml() != null) {
                        project.loadJellyScript(this.getReactorXml());
                    }
                    if (this.getGoals() != null) {
                        project.setGoalNames(this.getGoals());
                        this.beforeLaunchGoals(project);
                        this.getMavenContext().getMavenSession().attainGoals(project);
                        this.afterLaunchGoals(project);
                    }
                }
                catch (Exception e) {
                    this.onException(project, e);
                    if (this.isIgnoreFailures()) break block15;
                    throw new JellyTagException(e.fillInStackTrace());
                }
            }
            this.afterProject(project);
            if (this.getPostProcessing()) {
                this.reactorProjects.add(project);
            } else {
                project = null;
            }
            i2.remove();
        }
        this.getContext().setVariable("reactorProjects", (Object)this.reactorProjects);
        ArrayList c = (ArrayList)this.getContext().getVariable("failedProjects");
        if (c == null) {
            c = new ArrayList(this.failedProjects);
        } else {
            c.addAll(this.failedProjects);
        }
        this.getContext().setVariable("failedProjects", c);
    }

    public void beforeProject(Project project) {
    }

    public void beforeLaunchGoals(Project project) {
    }

    public void afterLaunchGoals(Project project) {
    }

    public void afterProject(Project project) {
    }

    public void onException(Project project, Exception e) {
        this.getMavenContext().setVariable("maven.build.failure", "true");
        this.failedProjects.add(project);
    }

    public void onDependencyResolutionException(Exception e) {
    }
}

