/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import org.apache.maven.project.BaseObject;
import org.apache.maven.util.EnhancedStringTokenizer;
import org.apache.maven.util.StringTool;

public class Repository
extends BaseObject {
    private String connection;
    private String developerConnection;
    private String url;

    public void setConnection(String connection) {
        this.connection = StringTool.trim(connection);
    }

    public void setDeveloperConnection(String developerConnection) {
        this.developerConnection = StringTool.trim(developerConnection);
    }

    public String getConnection() {
        return this.connection;
    }

    public String getDeveloperConnection() {
        return this.developerConnection;
    }

    public void setUrl(String url) {
        this.url = StringTool.trim(url);
    }

    public String getUrl() {
        return this.url;
    }

    public String getScmType() {
        if (this.isValid(this.getConnection())) {
            return this.getConnection().substring(4, this.connection.indexOf(":", 4));
        }
        return null;
    }

    public String getCvsRoot() {
        if (this.isValid(this.getConnection())) {
            return this.getConnection().substring(0, this.connection.lastIndexOf(":")).substring(7);
        }
        return null;
    }

    public String getCvsModule() {
        if (this.isValid(this.getConnection())) {
            return this.getConnection().substring(this.connection.lastIndexOf(":") + 1);
        }
        return null;
    }

    public String getCvsServer(String conn) {
        String[] tokens = Repository.splitSCMConnection(conn);
        if (tokens[3].indexOf(64) >= 0) {
            return tokens[3].substring(tokens[3].indexOf(64) + 1);
        }
        return tokens[3];
    }

    public String getCvsRoot(String conn, String username) {
        String[] tokens = Repository.splitSCMConnection(conn);
        if (tokens[3].indexOf(64) >= 0) {
            if (username.length() == 0) {
                username = tokens[3].substring(0, tokens[3].indexOf(64));
            }
            tokens[3] = username + "@" + tokens[3].substring(tokens[3].indexOf(64) + 1);
        }
        String result = ":" + tokens[2] + ":" + tokens[3] + ":" + tokens[4];
        return result;
    }

    public String getCvsModule(String conn) {
        String[] tokens = Repository.splitSCMConnection(conn);
        return tokens[5];
    }

    public static String[] splitSCMConnection(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.length() < 4) {
            throw new IllegalArgumentException("repository connection is too short");
        }
        if (!connection.startsWith("scm")) {
            throw new IllegalArgumentException("repository connection must start with scm[delim]");
        }
        String delimiter = "" + connection.charAt(3);
        EnhancedStringTokenizer tok = new EnhancedStringTokenizer(connection, delimiter);
        String[] tokens = Repository.tokenizerToArray(tok);
        if (tokens.length < 6) {
            throw new IllegalArgumentException("repository connection string contains less than six tokens");
        }
        if (tokens.length > 6) {
            throw new IllegalArgumentException("repository connection string contains more than six tokens");
        }
        return tokens;
    }

    public static String[] tokenizerToArray(EnhancedStringTokenizer tok) {
        ArrayList<String> l = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }
}

