/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import sun.misc.BASE64Encoder;

public class HttpUtils {
    public static void useProxyUser(String proxyHost, String proxyPort, final String proxyUserName, final String proxyPassword) {
        if (proxyHost != null && proxyPort != null) {
            ((Hashtable)System.getProperties()).put("proxySet", "true");
            ((Hashtable)System.getProperties()).put("proxyHost", proxyHost);
            ((Hashtable)System.getProperties()).put("proxyPort", proxyPort);
            if (proxyUserName != null) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUserName, proxyPassword == null ? new char[]{} : proxyPassword.toCharArray());
                    }
                });
            }
        }
    }

    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword, boolean useChecksum) throws Exception {
        block2: {
            HttpUtils.getFile(url, destinationFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword);
            if (!useChecksum) break block2;
            File checksumFile = new File(destinationFile + ".md5");
            try {
                HttpUtils.getFile(url + ".md5", checksumFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword) throws Exception {
        long remoteTimestamp;
        int length;
        String[] s = HttpUtils.parseUrl(url);
        String username = s[0];
        String password = s[1];
        String parsedUrl = s[2];
        URL source = new URL(parsedUrl);
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (useTimestamp && destinationFile.exists()) {
            timestamp = destinationFile.lastModified();
            hasTimestamp = true;
        }
        HttpUtils.useProxyUser(proxyHost, proxyPort, proxyUserName, proxyPassword);
        URLConnection connection = source.openConnection();
        if (useTimestamp && hasTimestamp) {
            connection.setIfModifiedSince(timestamp);
        }
        if (username != null || password != null) {
            String up = username + ":" + password;
            String encoding = null;
            try {
                BASE64Encoder encoder = (BASE64Encoder)Class.forName("sun.misc.BASE64Encoder").newInstance();
                encoding = encoder.encode(up.getBytes());
            }
            catch (Exception ex) {
                // empty catch block
            }
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (httpConnection.getResponseCode() == 404) {
                if (ignoreErrors) {
                    return;
                }
                throw new FileNotFoundException(url.toString() + " (HTTP Error: " + httpConnection.getResponseCode() + " " + httpConnection.getResponseMessage() + ")");
            }
            if (httpConnection.getResponseCode() == 304) {
                return;
            }
            if (httpConnection.getResponseCode() == 401) {
                if (ignoreErrors) {
                    return;
                }
                throw new Exception("Not authorized.");
            }
        }
        InputStream is = null;
        int i = 0;
        while (i < 3) {
            try {
                is = connection.getInputStream();
                break;
            }
            catch (IOException ex) {
                ++i;
            }
        }
        if (is == null) {
            if (ignoreErrors) {
                return;
            }
            throw new Exception("Can't get " + destinationFile.getName() + " to " + destinationFile);
        }
        FileOutputStream fos = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[102400];
        while ((length = is.read(buffer)) >= 0) {
            void var21_23;
            fos.write(buffer, 0, (int)var21_23);
            System.out.print(".");
        }
        System.out.println();
        fos.close();
        is.close();
        if (useTimestamp && (remoteTimestamp = connection.getLastModified()) != 0L) {
            HttpUtils.touchFile(destinationFile, remoteTimestamp);
        }
    }

    static String[] parseUrl(String url) {
        String[] parsedUrl = new String[]{null, null, url};
        int i = url.indexOf("@");
        if (i > 0) {
            String protocol = url.substring(0, url.indexOf("://")) + "://";
            String s = url.substring(protocol.length(), i);
            int j = s.indexOf(":");
            parsedUrl[0] = s.substring(0, j);
            parsedUrl[1] = s.substring(j + 1);
            parsedUrl[2] = protocol + url.substring(i + 1);
        }
        return parsedUrl;
    }

    private static boolean touchFile(File file, long timemillis) throws Exception {
        long modifiedTime = timemillis < 0L ? System.currentTimeMillis() : timemillis;
        file.setLastModified(modifiedTime);
        return true;
    }
}

