/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.project.Project;
import org.apache.tools.ant.types.Path;

public class MavenTool {
    private Project project;
    private Map counted = new HashMap();
    private Map countedItems = null;
    private Map countedItemsReversed = null;

    public Project getProject() {
        return this.project;
    }

    public String resolvePathFragment(String baseDir, String resource, Path directories) {
        return this.resolvePathFragment(baseDir, resource, directories.list());
    }

    protected final String resolvePathFragment(String baseDir, String resource, String[] paths) {
        String path = null;
        int i = 0;
        while (i < paths.length) {
            path = paths[i];
            File d = new File(baseDir, path);
            if (d.isDirectory() && new File(d, resource).exists()) break;
            path = null;
            ++i;
        }
        if (path == null) {
            System.err.println("Unable to resolve " + resource + " using a base diretory of " + baseDir);
        }
        return path;
    }

    public void resetCount() {
        this.getCounted().clear();
    }

    public void addToCount(Object object) {
        List<Object> list = null;
        list = this.getCounted().get(object) == null ? new ArrayList<Object>() : (List)this.getCounted().get(object);
        list.add(object);
        this.getCounted().put(object, list);
        if (this.getCountedItems() != null) {
            this.setCountedItems(null);
            this.setCountedItemsReversed(null);
        }
    }

    private void fillSortingMap(Map map) {
        List list = null;
        Object key = null;
        Iterator index = this.counted.keySet().iterator();
        while (index.hasNext()) {
            key = index.next();
            list = (List)this.counted.get(key);
            Integer count = new Integer(list.size());
            Set items = null;
            items = !map.containsKey(count) ? new TreeSet() : (Set)map.get(count);
            items.add(key);
            map.put(count, items);
        }
    }

    public Map getCountDescending() {
        if (this.getCountedItemsReversed() == null) {
            this.setCountedItemsReversed(new TreeMap(Collections.reverseOrder()));
            this.fillSortingMap(this.getCountedItemsReversed());
        }
        return this.getCountedItemsReversed();
    }

    public Map getCount() {
        if (this.getCountedItems() == null) {
            this.setCountedItems(new TreeMap());
            this.fillSortingMap(this.getCountedItems());
        }
        return this.getCountedItems();
    }

    private Map getCounted() {
        return this.counted;
    }

    private Map getCountedItems() {
        return this.countedItems;
    }

    private void setCountedItems(Map countedItems) {
        this.countedItems = countedItems;
    }

    private Map getCountedItemsReversed() {
        return this.countedItemsReversed;
    }

    private void setCountedItemsReversed(Map countedItemsReversed) {
        this.countedItemsReversed = countedItemsReversed;
    }

    public Integer toInteger(String s) {
        return Integer.valueOf(s);
    }
}

