/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate {
    private static final String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Nestable cause = null;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    NestableDelegate(Nestable cause) {
        if (!(cause instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.cause = cause;
    }

    int getLength() {
        int count = 1;
        Object msg = null;
        if (this.cause.getCause() == null) {
            return count;
        }
        Throwable t = this.cause.getCause();
        while (t != null) {
            ++count;
            t = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(t) ? ((Nestable)((Object)t)).getCause() : null;
        }
        return count;
    }

    String getMessage(String baseMsg) {
        String causeMsg;
        Throwable nestedCause;
        StringBuffer msg = new StringBuffer();
        if (baseMsg != null) {
            msg.append(baseMsg);
        }
        if ((nestedCause = this.cause.getCause()) != null && (causeMsg = nestedCause.getMessage()) != null) {
            if (baseMsg != null) {
                msg.append(": ");
            }
            msg.append(causeMsg);
        }
        return msg.length() > 0 ? msg.toString() : null;
    }

    String getMessage(int index) {
        Throwable t;
        if ((class$org$apache$commons$lang$exception$Nestable == null ? (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")) : class$org$apache$commons$lang$exception$Nestable).isInstance(t = this.getThrowable(index))) {
            return ((Nestable)((Object)t)).getMessage(0);
        }
        return t.getMessage();
    }

    Throwable getThrowable(int index) {
        Throwable[] throwables = this.getThrowables();
        if (index < 0) {
            index = 0;
        }
        if (index == 0) {
            return (Throwable)((Object)this.cause);
        }
        if (index >= throwables.length) {
            index = throwables.length - 1;
        }
        return throwables[index];
    }

    Throwable[] getThrowables() {
        int count = this.getLength();
        Throwable[] throwables = new Throwable[count];
        count = 0;
        if (this.cause != null) {
            throwables[count++] = (Throwable)((Object)this.cause);
            Throwable t = this.cause.getCause();
            while (t != null) {
                throwables[count++] = t;
                t = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(t) ? ((Nestable)((Object)t)).getCause() : null;
            }
        }
        return throwables;
    }

    String[] getMessages() {
        Throwable[] throwables = this.getThrowables();
        String[] msgs = new String[throwables.length];
        int i = 0;
        while (i < throwables.length) {
            msgs[i] = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(throwables[i]) ? ((Nestable)((Object)throwables[i])).getMessage(0) : throwables[i].getMessage();
            ++i;
        }
        return msgs;
    }

    int indexOfThrowable(int pos, Class type) {
        pos = pos < 0 ? 0 : pos;
        Throwable[] throwables = this.getThrowables();
        int i = pos = pos >= throwables.length ? throwables.length - 1 : pos;
        while (i < throwables.length) {
            if (throwables[i].getClass().equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(System.err);
        }
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            String[] st = this.decompose((Throwable)((Object)this.cause));
            Throwable nestedCause = this.cause.getCause();
            if (nestedCause != null) {
                if (nestedCause instanceof Nestable) {
                    ((Nestable)((Object)nestedCause)).printStackTrace(out);
                } else {
                    String[] nst = this.decompose(nestedCause);
                    int i = 0;
                    while (i < nst.length) {
                        out.println(nst[i]);
                        ++i;
                    }
                }
                out.print("rethrown as ");
            }
            int i = 0;
            while (i < st.length) {
                out.println(st[i]);
                ++i;
            }
        }
    }

    private String[] decompose(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (t instanceof Nestable) {
            ((Nestable)((Object)t)).printPartialStackTrace(pw);
        } else {
            t.printStackTrace(pw);
        }
        String linebreak = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(sw.getBuffer().toString(), linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

