/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLOutput
implements ContentHandler,
LexicalHandler {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    public XMLOutput() {
    }

    public XMLOutput(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public XMLOutput(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public String toString() {
        return super.toString() + "[contentHandler=" + this.contentHandler + ";lexicalHandler=" + this.lexicalHandler + "]";
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
        ((XMLWriter)this.contentHandler).flush();
    }

    public static XMLOutput createXMLOutput(XMLReader xmlReader) {
        XMLOutput output = new XMLOutput(xmlReader.getContentHandler());
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            try {
                Object value = xmlReader.getProperty(LEXICAL_HANDLER_NAMES[i]);
                if (!(value instanceof LexicalHandler)) continue;
                output.setLexicalHandler((LexicalHandler)value);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return output;
    }

    public static XMLOutput createXMLOutput(Writer writer) {
        XMLWriter xmlWriter = new XMLWriter(writer);
        return XMLOutput.createXMLOutput(xmlWriter);
    }

    public static XMLOutput createXMLOutput(Writer writer, boolean escapeText) throws UnsupportedEncodingException {
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.setEscapeText(escapeText);
        return XMLOutput.createXMLOutput(xmlWriter);
    }

    public static XMLOutput createXMLOutput(OutputStream out) throws UnsupportedEncodingException {
        XMLWriter xmlWriter = new XMLWriter(out);
        return XMLOutput.createXMLOutput(xmlWriter);
    }

    public static XMLOutput createXMLOutput(OutputStream out, boolean escapeText) throws UnsupportedEncodingException {
        XMLWriter xmlWriter = new XMLWriter(out);
        xmlWriter.setEscapeText(escapeText);
        return XMLOutput.createXMLOutput(xmlWriter);
    }

    public static XMLOutput createDummyXMLOutput() {
        return new XMLOutput(new DefaultHandler());
    }

    public void write(String text) throws SAXException {
        char[] ch = text.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    public void writeCDATA(String text) throws SAXException {
        this.startCDATA();
        char[] ch = text.toCharArray();
        this.characters(ch, 0, ch.length);
        this.endCDATA();
    }

    public void writeComment(String text) throws SAXException {
        char[] ch = text.toCharArray();
        this.comment(ch, 0, ch.length);
    }

    public void startElement(String localName) throws SAXException {
        this.startElement("", localName, localName, EMPTY_ATTRIBUTES);
    }

    public void startElement(String localName, Attributes attributes) throws SAXException {
        this.startElement("", localName, localName, attributes);
    }

    public void endElement(String localName) throws SAXException {
        this.endElement("", localName, localName);
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler cannot be null!");
        }
        this.contentHandler = contentHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    protected static XMLOutput createXMLOutput(final XMLWriter xmlWriter) {
        XMLOutput answer = new XMLOutput(){

            public void close() throws IOException {
                xmlWriter.close();
            }
        };
        answer.setContentHandler((ContentHandler)xmlWriter);
        answer.setLexicalHandler((LexicalHandler)xmlWriter);
        return answer;
    }
}

