/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.Expression;

public abstract class ExpressionSupport
implements Expression {
    protected static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();

    public String evaluateAsString(JellyContext context) {
        Object value = this.evaluateRecurse(context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Object evaluateRecurse(JellyContext context) {
        Object value = this.evaluate(context);
        if (value instanceof Expression) {
            Expression expression = (Expression)value;
            return expression.evaluateRecurse(context);
        }
        return value;
    }

    public boolean evaluateAsBoolean(JellyContext context) {
        Object value = this.evaluateRecurse(context);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.equals("on") || str.equals("yes") || str.equals("1") || str.equals("true");
        }
        return false;
    }

    public Iterator evaluateAsIterator(JellyContext context) {
        Object value = this.evaluateRecurse(context);
        if (value == null) {
            return EMPTY_ITERATOR;
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.iterator();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet().iterator();
        }
        if (value.getClass().isArray()) {
            return new ArrayIterator(value);
        }
        if (value instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.iterator();
        }
        return new SingletonIterator(value);
    }

    public abstract /* synthetic */ Object evaluate(JellyContext var1);

    public abstract /* synthetic */ String getExpressionText();
}

