/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.io.File;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class IncludeTag
extends TagSupport {
    private String uri;
    private File file;
    private boolean shouldExport = false;
    private boolean shouldInherit = true;

    public void setInherit(String inherit) {
        if ("true".equals(inherit)) {
            this.shouldInherit = true;
        }
    }

    public void setExport(String export) {
        if ("true".equals(export)) {
            this.shouldExport = true;
        }
    }

    public boolean isInherit() {
        return this.shouldInherit;
    }

    public boolean isExport() {
        return this.shouldExport;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.uri == null && this.file == null) {
            throw new MissingAttributeException("uri");
        }
        String text = null;
        try {
            if (this.uri != null) {
                text = this.uri;
                this.context.runScript(this.uri, output, this.isExport(), this.isInherit());
            } else {
                text = this.file.toString();
                this.context.runScript(this.file, output, this.isExport(), this.isInherit());
            }
        }
        catch (JellyException e) {
            throw new JellyTagException("could not include jelly script: " + text + ". Reason: " + e, e);
        }
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

